﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace de.WWWings
{

 /// <summary>
 /// Basisklasse für Mitarbeiter und Passagiere
 /// </summary>
  [System.Serializable()]
 public class Person 
 {
  // ========== Attribute (Fields)
	 private string _PersonalausweisNr;

	 public string PersonalausweisNr
	 {
		 get { return _PersonalausweisNr; }
		 set { _PersonalausweisNr = value; }
	 }
	 private string _Vorname;

	 public string Vorname
	 {
		 get { return _Vorname; }
		 set { _Vorname = value; }
	 }
	 private string _Nachname;

	 public string Nachname
	 {
		 get { return _Nachname; }
		 set { _Nachname = value; }
	 }

  private DateTime _Geburtsdatum;

	public DateTime Geburtsdatum
	{
		get { return _Geburtsdatum;}
		set { _Geburtsdatum = value;}
	}
	
  //  ========== Errechnete Attribute (Properties)

  /// <summary>
  /// Liefert Vorname und Nachname
  /// </summary>
  public string GanzerName
  {
   get
   {
    return this.Vorname + " " + this.Nachname;
   }
  }

  /// <summary>
  /// Liefert das Alter (annähernd).
  /// </summary>
  public int Alter
  {
   get { return ((DateTime.Now - this.Geburtsdatum)).Days / 365; }
  }

  // ========== Konstruktoren
  public Person()
  {
  }
  public Person(string Nachname, string Vorname)
  {
   this.Vorname = Vorname;
   this.Nachname = Nachname;
  }
  // ========== Methoden

  /// <summary>
  /// Testfunktion für Objekt
  /// </summary>
  public virtual void Info()
  {
   Console.WriteLine("Person: " + this.GanzerName);
  }
 }
}
