﻿#region Using directives

using System;
using System.Text;

#endregion
using de.WWWings;
using System.Collections.Generic; // normaler Import
using GenCol = System.Collections.Generic; // Import mit Alias

namespace de.WWWings.PassagierSystem
{

 /// <summary>
 /// Eine Menge von Passagieren
 /// </summary>
 [System.CLSCompliant(false)]
 public class PassagierMenge : System.Collections.Generic.List<Passagier>
 {
 }

 /// <summary>
 /// Eine Menge von Buchungen
 /// </summary>
 [System.CLSCompliant(false)]
 public class BuchungsMenge : System.Collections.Generic.List<Buchung>
 {
  public override string ToString()
  {
   if (this.Count == 0) return "keine";
   string Ausgabe = "";
   foreach (Buchung b in this)
   {
    Ausgabe += b.Buchungscode + ": von " + b.Abflugort + " nach " + b.Zielort + "\n";
   }
   return Ausgabe;
  }
 }

 /// <summary>
 /// Eine Menge von Passagieren
 /// </summary>
 [System.CLSCompliant(false)]
 public class Passagiere : System.Collections.Generic.SortedList<long, Passagier>
 {
  public Passagier Passagier
  {
   get
   {
    throw new System.NotImplementedException();
   }
   set
   {
   }
  }




  /// <summary>
  /// Nächste verfügbare Passagiernummer
  /// </summary>
  /// <returns></returns>
  private long NaechstePassagierNummer()
  {
   if (base.Count == 0)
   {
    return 1;
   }
   else
   {
    return base.Keys[base.Count - 1] + 1;
   }
  }

  public long Add(Passagier P)
  {
   long pnr = this.NaechstePassagierNummer();
   base.Add(pnr, P);
   return pnr;
  }
 }
}
