using System;
using System.Collections.Generic;
using System.Text;
using de.WWWings.PassagierSystem;

namespace de.WWWings.ORM
{

 /// <summary>
 /// Hndische Implementierung des Objek-Relationalen Mappings fr die Tabelle GF_GebuchteFluege auf die Klassen Buchung und BuchungsMenge.<remarks>
 /// In World Wide Wings wird bewut keins der am Markt verfgbaren Drittanbieterwerkzeuge fr ORM eingesetzt, da erstens die Komplexitt des Beispiels nicht weiter erhht werden soll und zweitens eine Marktbereinigung zu erwarten ist, sobald Microsoft die angekndigten ORM-Werkzeuge auf den Markt bringt.</remarks>
 /// </summary>
 class ORM_Buchung
 {
  /// <summary>
  /// Mapping fr DataRow "zu Fu programmiert!"
  /// </summary>
  public static Buchung MapRow(System.Data.DataRow dr)
  {
   Buchung b = new Buchung(Convert.ToInt64(dr["GF_FL_FlugNr"]), Convert.ToInt64(dr["GF_PS_ID"]));
   b.Buchungscode = Convert.ToInt64(dr["GF_Buchungscode"]);
   return b;
  }

  /// <summary>
  /// Mapping fr DataTable
  /// </summary>
  /// <param name="dt">DataTable-Objekt</param>
  /// <returns>Menge von Passagier-Objekten</returns>
  public static de.WWWings.PassagierSystem.BuchungsMenge MapTable(System.Data.DataTable dt)
  {
   BuchungsMenge bb = new BuchungsMenge();
   foreach (System.Data.DataRow dr in dt.Rows)
   {
    Buchung b = MapRow(dr);
    bb.Add(b);
   }
   return bb;
  }
 }
}
