Imports Microsoft.VisualBasic
Imports System
Imports System.Text
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings
Imports System.EnterpriseServices
Imports System.Runtime.CompilerServices
Imports de.ITVisions.DALUtil

Namespace de.WWWings.DAL

 ''' <summary>
 ''' Datenzugriffsmanager fr die Tabelle Passagier
 ''' Alternative 1 von 3
 ''' Verwendet Transaktionen in .NET Enterprise Services
 ''' atenzugriffsschicht fr die Passagiere
 ''' </summary>
 <Description("DataManager fr Tabelle PS_Passagiere"), Transaction(TransactionOption.Required), ObjectPoolingAttribute(True, 0, 20), EventTrackingEnabled(True), System.EnterpriseServices.Synchronization(SynchronizationOption.Required), System.Runtime.InteropServices.Guid("9C74BA6A-9D1C-4fe7-808E-04E6665D0250")> _
 Public Class Passagier_DataManager : Inherits System.EnterpriseServices.ServicedComponent

  ''' <summary>
  ''' Konstruktor: Setzen der Datenbank
  ''' </summary>
  Public Sub New()
   DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL)
   'DBUtil.SetDatabase(DBUtil.Providers.ACCESS, CONN_ACCESS);
  End Sub

  Public Sub New(ByVal x As String)
  End Sub
  ''' <summary>
  ''' Fhrt eine einzelne Flugbuchung aus. 
  ''' </summary>
  Public Function Buchung(ByVal PS_ID As Long, ByVal FL_ID As Long) As Long
   Dim RestPlaetze As Long = 0
   Try
    RestPlaetze = Buche(PS_ID, FL_ID)
    System.EnterpriseServices.ContextUtil.SetComplete()
   Catch ex As Exception
    System.EnterpriseServices.ContextUtil.SetAbort()
    Throw ex
   End Try
   Return RestPlaetze
  End Function

  ''' <summary>
  ''' Fhrt eine Menge von Flugbuchungen aus
  ''' </summary>
  <AutoComplete()> _
  Public Sub MehrfachBuchung(ByVal PS_ID As Long, ByVal FL_IDs As Long())
   For Each FL_ID As Long In FL_IDs
    Buche(PS_ID, FL_ID)
   Next FL_ID
  End Sub

  ''' <summary>
  ''' Fhrt eine einzelne Flugbuchungen  aus. Erzeugt eine Ausnahme, wenn es einen Fehler gab.
  ''' </summary>
  Private Function Buche(ByVal PS_ID As Long, ByVal FL_ID As Long) As Long
   ' Prototyp: Daten tlw. statisch!
   Dim SQL1 As String = "Select * From FL_Fluege where FL_Flugnr=" & FL_ID
   Dim SQL2 As String = "INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " & "VALUES (" & PS_ID & "," & FL_ID & ", 0, 'F')"
   ' --- Versuche Platzanzahl zu reduzieren
   Dim ds As DataSet = DBUtil.GetDataSet(SQL1)
   If ds.Tables(0).Rows.Count = 0 Then
    Throw New ApplicationException("Flug nicht vorhanden: " & FL_ID)
   End If
   Dim Plaetze As Long = Convert.ToInt32(ds.Tables(0).Rows(0)("FL_FreiePlaetze"))
   If Plaetze = 0 Then
    Throw New ApplicationException("Keine Pltze vorhanden fr Flug " & FL_ID)
   End If
   Plaetze -= 1
   ds.Tables(0).Rows(0)("FL_FreiePlaetze") = Plaetze
   Try
    DBUtil.UpdateDS(ds, SQL1)
   Catch
    Throw New ApplicationException("Platzreduzierung nicht erfolgreich. Flug=" & FL_ID)
   End Try
   ' --- Versuche, Flug zu buchen
   Try
    DBUtil.Execute(SQL2)
   Catch ex As Exception
    Throw New ApplicationException("Fehler beim Buchen fr Flug " & FL_ID, ex)
   End Try
   ' Alle Buchungen erfolgreich!
   Return Plaetze
  End Function


  ''' <summary>
  ''' Lschen aller Buchungen
  ''' </summary>
  <AutoComplete()> _
  Public Function AlleBuchungenLoeschen(ByVal PS_ID As Long) As Long
   Dim SQL As String = "Delete from GF_GebuchteFluege where GF_PS_ID = " & PS_ID
   Return SQLUtil.Execute(SQL)
  End Function

  Public Function AlleBuchungen(ByVal PS_ID As Long) As SqlDataReader
   Dim SQL As String = "Select * from GF_GebuchteFluege where GF_PS_ID = " & PS_ID
   Return SQLUtil.GetReader(SQL)
  End Function

 End Class
End Namespace
