﻿using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;
using de.ITVisions.DALUtil;

namespace de.WWWings.DAL
{

 /// <summary>
 /// Datenzugriffsmanager für die Tabelle Passagier
 /// Alternative 3 von 3
 /// Verwendet Transaktionen mit Services without Components (SWC)
 /// </summary>
 public class Passagier_DataManager_SWC
 {
  const string CONN_MSSQL = @"Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=WorldWideWings;Data Source=MARL\sqlexpress";
  const string CONN_ACCESS = @"Provider='Microsoft.Jet.OLEDB.4.0';Data Source='E:\N2C\WorldWideWings\Datenbanken\WorldWideWings.mdb'";

  /// <summary>
  /// Konstruktor: Setzen der Datenbank
  /// </summary>
  public Passagier_DataManager_SWC()
  {
	  DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL);
   //DBUtil.SetDatabase(DBUtil.Providers.ACCESS, CONN_ACCESS);
  }

  /// <summary>
  /// Führt eine einzelne Flugbuchung aus. 
  /// </summary>
  public long Buchung(long PS_ID, long FL_ID)
  {
   try
   {
    // --- DTC-Transaktionen vorbereiten
    ServiceConfig sc = new ServiceConfig();
    sc.TrackingEnabled = true;
    sc.TrackingAppName = "WorldWideWings_SWC";
    sc.TrackingComponentName = this.GetType().FullName;
    sc.Transaction = TransactionOption.Required;
    ServiceDomain.Enter(sc);

    // -- Verarbeitung kann jetzt beginnen...
    long RestPlaetze = 0;
  
    try
    {
     RestPlaetze = Buche(PS_ID, FL_ID);
     System.EnterpriseServices.ContextUtil.SetComplete();
     return RestPlaetze;
    }
    catch (Exception ex)
    {
     System.EnterpriseServices.ContextUtil.SetAbort();
     throw ex;
    }

   }
   finally
   {
    ServiceDomain.Leave();
   }
  }

  /// <summary>
  /// Führt eine Menge von Flugbuchungen aus
  /// </summary>
  [AutoComplete]
  public void MehrfachBuchung(long PS_ID, long[] FL_IDs)
  {
   foreach (long FL_ID in FL_IDs)
   {
    Buche(PS_ID, FL_ID);
   }
  }


  /// <summary>
  /// Führt eine einzelne Flugbuchungen  aus. Erzeugt eine Ausnahme, wenn es einen Fehler gab.
  /// </summary>
  private long Buche(long PS_ID, long FL_ID)
  {
   // Prototyp: Daten tlw. statisch!
   string SQL1 = @"Select * From FL_Fluege where FL_Flugnr=" + FL_ID;
   string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (" + PS_ID + "," + FL_ID + ", 0, 'F')";
   // --- Versuche Platzanzahl zu reduzieren
   DataSet ds = DBUtil.GetDataSet(SQL1);
   if (ds.Tables[0].Rows.Count == 0) throw new ApplicationException("Flug nicht vorhanden: " + FL_ID);
   long Plaetze = Convert.ToInt32(ds.Tables[0].Rows[0]["FL_FreiePlaetze"]);
   if (Plaetze == 0) throw new ApplicationException("Keine Plätze vorhanden für Flug " + FL_ID);
   Plaetze--;
   ds.Tables[0].Rows[0]["FL_FreiePlaetze"] = Plaetze;
   try
   {
    DBUtil.UpdateDS(ds, SQL1);
   }
   catch
   {
    throw new ApplicationException("Platzreduzierung nicht erfolgreich. Flug=" + FL_ID);
   }
   // --- Versuche, Flug zu buchen
   try
   {
    DBUtil.Execute(SQL2);
   }
   catch (Exception ex)
   {
    throw new ApplicationException("Fehler beim Buchen für Flug " + FL_ID, ex);
   }
   // Alle Buchungen erfolgreich!
   return Plaetze;
  }


  [AutoComplete]
  public long AlleBuchungenLoeschen(long PS_ID)
  {
   string SQL = "Delete from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return DBUtil.Execute(SQL);
  }

  public DbDataReader AlleBuchungen(long PS_ID)
  {
   string SQL = "Select * from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return DBUtil.GetReader(SQL);
  }

 }
}
