using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;
using de.ITVisions.DALUtil;

namespace de.WWWings.DAL
{

 /// <summary>
 /// Datenzugriffsmanager fr die Tabelle Passagier
 /// Alternative 2 von 3
 /// Verwendet Transaktionen mit System.Transactions
 /// </summary>
 /// <summary>
 /// Datenzugriffsschicht fr die Passagiere
 /// </summary>
 public class Passagier_DataManager_ST
 {

  /// <summary>
  /// Konstruktor: Setzen der Datenbank
  /// </summary>
  public Passagier_DataManager_ST()
  {
   DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL);
   //DBUtil.SetDatabase(DBUtil.Providers.ACCESS, CONN_ACCESS);
  }

  public Passagier_DataManager_ST(string x)
  {
  }

  /// <summary>
  /// Hinzufgen eines Flugs
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="FL_FlugNr"></param>

  public static void Insert(string FL_Abflugort, string FL_ZielOrt, bool FL_NichtRaucherFlug, long FL_Plaetze, DateTime FL_EingerichtetAm, int FL_FlugNr)
  {
   DBUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, Fl_Plaetze, Fl_NichtraucherFlug) Values (" + FL_FlugNr + ",'" + FL_Abflugort + "', '" + FL_ZielOrt + "', " + FL_Plaetze + ", '" + FL_NichtRaucherFlug + "')");
  }


  /// <summary>
  /// Passagieranlegen
  /// </summary>

  public static void Anlegen(long Personalausweisnummer, string Vorname, string Nachname, string Land, byte Kundenstatus, DateTime KundenstatusSeit)
  {

   try
   {
    DBUtil.Execute("Insert into PE_Person (PE_PersonalausweisNr, PE_Vorname, PE_Name, PE_Land) Values (" + Personalausweisnummer + ",'" + Vorname + "', '" + Nachname + "', '" + Land + "')");
   }
   catch (Exception)
   {

   }

   DBUtil.Execute("Insert into PS_Passagier (PS_PE_Personalausweisnummer, PS_Kundenstatus, PS_KundenstatusSeit) Values (" + Personalausweisnummer + "," + Kundenstatus + ",'" + KundenstatusSeit.ToString(new System.Globalization.CultureInfo("en-us")) + "')");
  }


  public static long HolePassagierNummer(string Vorname, string Nachname)
  {
   string SQL = "Select PS_ID from AllePassagiere where PE_Vorname='" + Vorname + "' and PE_Name = '" + Nachname + "'";
   DataSet ds = DBUtil.GetDataSet(SQL);
   if (ds.Tables[0].Rows.Count == 0) return 0;
   else return Convert.ToInt64(ds.Tables[0].Rows[0][0]);
  }

  /// <summary>
  /// Holt einen Passagier anhand der Passagiernummer aus der Datenbank als DataRow
  /// </summary>
  public static DataRow HolePassagier(long Nummer)
  {
   string SQL = "Select * from AllePassagiere where PS_ID=" + Nummer;
   DataSet ds = DBUtil.GetDataSet(SQL);
   if (ds.Tables[0].Rows.Count == 0) return null;
   else return ds.Tables[0].Rows[0];
  }

  /// <summary>
  /// Holt alle Passagiere aus der Datenbank als DataTable
  /// </summary>
  public static DataTable AllePassagiere()
  {
   string SQL = "Select * from AllePassagiere";
   DataSet ds = DBUtil.GetDataSet(SQL);
   return ds.Tables[0];
  }

  /// <summary>
  /// Fhrt eine einzelne Flugbuchung aus. 
  /// </summary>
  public long Buchung(long Buchungscode, long PS_ID, long FL_ID)
  {
   // --- Beginn der Transaktion
   //System.Transactions.TransactionScope tx = new System.Transactions.TransactionScope();
   // --- Verarbeitung kann jetzt beginnen...
   long RestPlaetze = 0;

   RestPlaetze = Buche(Buchungscode, PS_ID, FL_ID);
   // --- Transaktion abschlieen
   //tx.Complete();
   //// --- Transaktionsobjekt verwerfen
   //tx.Dispose();
   return RestPlaetze;
  }


  /// <summary>
  /// Fhrt eine Menge von Flugbuchungen aus
  /// </summary>

  public static void MehrfachBuchung(long BuchungsCode, long PS_ID, long[] FL_IDs)
  {

   //using (System.Transactions.TransactionScope tx = new System.Transactions.TransactionScope())
   //{
    foreach (long FL_ID in FL_IDs)
    {
     Buche(BuchungsCode, PS_ID, FL_ID);
    }
   // tx.Complete();
   //}
  }

  /// <summary>
  /// Fhrt eine einzelne Flugbuchungen  aus. Erzeugt eine Ausnahme, wenn es einen Fehler gab.
  /// </summary>

  private static long Buche(long Buchungscode, long PS_ID, long FL_ID)
  {
   // WORKAROUND: Buchung erst lschen, wenn schon vorhanden
   string SQL = @"delete from GF_GebuchteFluege where GF_FL_FlugNr=" + FL_ID + " and GF_PS_ID= " + PS_ID;
   long e = DBUtil.Execute(SQL);

   // Prototyp: Daten tlw. statisch!
   string SQL1 = @"Select * From FL_Fluege where FL_Flugnr=" + FL_ID;
   string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse], [GF_Buchungscode]) " + "VALUES (" + PS_ID + "," + FL_ID + ", 0, 'F'," + Buchungscode.ToString() + ")";
   // --- Versuche Platzanzahl zu reduzieren
   DataSet ds = DBUtil.GetDataSet(SQL1);
   if (ds.Tables[0].Rows.Count == 0) throw new ApplicationException("Flug nicht vorhanden: " + FL_ID);
   long Plaetze = Convert.ToInt32(ds.Tables[0].Rows[0]["FL_FreiePlaetze"]);
   if (Plaetze == 0) throw new ApplicationException("Keine Pltze vorhanden fr Flug " + FL_ID);
   Plaetze--;
   ds.Tables[0].Rows[0]["FL_FreiePlaetze"] = Plaetze;
   try
   {
    DBUtil.UpdateDS(ds, SQL1);
   }
   catch (Exception ex)
   {
    throw new ApplicationException("Platzreduzierung nicht erfolgreich. Flug=" + FL_ID + " " + ex.Message);
   }
   // --- Versuche, Flug zu buchen
   try
   {
    DBUtil.Execute(SQL2);
   }
   catch (Exception ex)
   {
    throw new ApplicationException("Fehler beim Buchen von Flug " + FL_ID + " fr Passagier " + PS_ID + ": " + ex.Message, ex);
   }


   // Alle Buchungen erfolgreich!
   return Buchungscode;
  }


  /// <summary>
  /// Lschen aller Buchungen
  /// </summary>

  public static long AlleBuchungenLoeschen(long PS_ID)
  {
   string SQL = "Delete from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return DBUtil.Execute(SQL);
  }

  /// <summary>
  /// Lschen aller Buchungen
  /// </summary>

  public static long AlleBuchungenLoeschen()
  {
   string SQL = "Delete from GF_GebuchteFluege";
   return DBUtil.Execute(SQL);
  }

  /// <summary>
  /// Lschen aller Buchungen
  /// </summary>

  public static long BuchungenLoeschen(long Buchungscode)
  {
   string SQL = "Delete from GF_GebuchteFluege where GF_Buchungscode = " + Buchungscode;
   return DBUtil.Execute(SQL);
  }


  public static DbDataReader AlleBuchungen_Reader(long PS_ID)
  {
   string SQL = "Select * from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return DBUtil.GetReader(SQL);
  }


  public static DataTable AlleBuchungen_DataTable(long PS_ID)
  {
   string SQL = "Select * from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return DBUtil.GetDataTable(SQL);
  }

  public static DataTable AlleBuchungenMitCode_DataTable(long code)
  {
   string SQL = "Select * from GF_GebuchteFluege where GF_Buchungscode = " + code;
   return DBUtil.GetDataTable(SQL);
  }

  /// <summary>
  /// Anzahl der Datenstze ermitteln
  /// </summary>
  /// <returns></returns>
  public static int CountPassagiere()
  {
   return (int)(DBUtil.Count("Select count(*) from AllePassagiere"));
  }

  /// <summary>
  /// Anzahl der Datenstze ermitteln
  /// </summary>
  /// <returns></returns>
  public static int CountBuchungen()
  {
   return (int)(DBUtil.Count("Select count(*) from GF_GebuchteFluege"));
  }

 }
}
