﻿Imports de.ITVisions.DemoViewer
Imports System.Data.SqlClient
Imports System.Xml
Imports System.Xml.Schema

<Demo()> Public Class XMLReaderDemo


 ' === Komplettes Durchlaufen der Flugliste (erster naiver Ansatz!)
 Sub LeseFlugdaten1()
  Dim rs As XmlReaderSettings = New XmlReaderSettings
  rs.ConformanceLevel = ConformanceLevel.Fragment
  rs.IgnoreWhitespace = True
  rs.IgnoreComments = True
  Dim r As XmlReader = XmlReader.Create("..\..\daten\Flugliste.xml", rs)

  ' --- Schleife zum Lesen
  Do While r.Read
   'If r.Name = "Details" Then r.Skip() ' Knoten überspringen
   Demo.Print(StrDup(r.Depth, " ") & r.Name & " (" & r.NodeType.ToString & ")")
   If r.HasAttributes Then
    Dim i As Integer
    For i = 0 To r.AttributeCount - 1
     r.MoveToAttribute(i)
     Demo.Print(StrDup(r.Depth, " ") & "- " & r.Name & "=" & r.Value & " (" & r.NodeType.ToString & ")")
    Next i
   End If
  Loop
  r.Close()
 End Sub

 ' === Komplettes Durchlaufen der Flugliste (strukturiert!)
 Sub LeseFlugdaten2()
  Dim settings As XmlReaderSettings = New XmlReaderSettings
  settings.ConformanceLevel = ConformanceLevel.Fragment
  settings.IgnoreWhitespace = True
  settings.IgnoreComments = True
  Dim r As XmlReader = XmlReader.Create("..\..\daten\Flugliste.xml", settings)

  ' --- Schleife zum Lesen
  Do While r.Read
   If (Not r.NodeType = XmlNodeType.EndElement) Then
    Dim EingerichtetAm As Boolean
    If Not r.HasValue Then
     Demo.Print(StrDup(r.Depth, " ") & r.Name & " (" & r.NodeType.ToString & ")")
     If r.Name = "EingerichtetAm" Then EingerichtetAm = True
    Else
     If EingerichtetAm Then
      Demo.Print(StrDup(r.Depth, " ") & "'" & r.ReadContentAsDateTime & "' (" & r.NodeType.ToString & ")")
      EingerichtetAm = False
     Else
      Demo.Print(StrDup(r.Depth, " ") & "'" & r.Value & "' (" & r.NodeType.ToString & ")")
     End If
    End If
   End If

   If r.HasAttributes Then
    Dim i As Integer
    For i = 0 To r.AttributeCount - 1
     r.MoveToAttribute(i)
     Demo.Print(StrDup(r.Depth, " ") & "- " & r.Name & "=" & r.Value & " (" & r.NodeType.ToString & ")")
    Next i
   End If
  Loop
  r.Close()
 End Sub


 Dim Fehler As Boolean
 ' === Komplettes Durchlaufen der Flugliste (mit Validierung)

 Sub LeseFlugdaten3()
  Dim rs As XmlReaderSettings = New XmlReaderSettings
  rs.ConformanceLevel = ConformanceLevel.Fragment
  rs.IgnoreWhitespace = True
  rs.IgnoreComments = True
  rs.ValidationType = ValidationType.Schema
  rs.Schemas.Add(Nothing, "..\..\daten\Flugliste1.xsd")
  Dim r As XmlReader = XmlReader.Create("..\..\daten\Flugliste.xml", rs)

  ' --- Ereignisbehandlung festlegen
  AddHandler rs.ValidationEventHandler, AddressOf ValidationsFehler

  Demo.Print("Validierung beginnt...")

  ' --- Daten einlesen und dabei validieren!
  While r.Read() : End While

  If Fehler Then
   Demo.Print("Validierung fehlgeschlagen!")
  Else
   Demo.Print("Validierung erfolgreich beendet!")
  End If
  r.Close()
 End Sub 'Validate

 ' === Validierungsfehler anzeigen
 Public Sub ValidationsFehler(ByVal sender As Object, ByVal args As ValidationEventArgs)
  Fehler = True
  Demo.Print(("Fehler: " & args.Message))
 End Sub



End Class
