using System;
using System.Collections.Generic;
using System.Text;

namespace de.ITVisions.DALUtil
{

 /// <summary>
 ///  Dies ist ein Beispiel fr eine Implementierung einer Hilfsbibliothek zur Nutzung 
 /// von ADO.NET, aus der Sicht des Nutzers viele Funktionen von ADO.NET auf eine 
 /// Codezeile reduziert.<br/>
 /// Klasse zum Konfigurieren der DALUtil-Bibliothek
 /// </summary>
 public class DBConfig
 {

  //public const string CONN_MSSQL = @"Data Source=.\sqlexpress;Initial Catalog=WWWings;Integrated Security=True";

  const string CONFIG_CONNSTRING_NAME = "CS_WWWings";
  static private string _CurrentConnString;
  static public string CurrentConnString
  {
   get
   {
    if (_CurrentConnString == null) _CurrentConnString = System.Configuration.ConfigurationManager.ConnectionStrings[CONFIG_CONNSTRING_NAME].ConnectionString;
    return _CurrentConnString;
   }
   set { _CurrentConnString = value; }
  }

  static private string _CurrentProvider;
  static public string CurrentProvider
  {
   get
   {
    if (_CurrentProvider == null) _CurrentProvider = System.Configuration.ConfigurationManager.ConnectionStrings[CONFIG_CONNSTRING_NAME].ProviderName;
    return _CurrentProvider;
   }
   set { _CurrentProvider = value; }
  }



  /// <summary>
  /// Aktuelle MSSQL-Datenbank
  /// </summary>
  public static string CONN_MSSQL
  {
   get
   {
    string CS = "";
    try
    {
     CS = System.Configuration.ConfigurationManager.ConnectionStrings["CS_WWWings"].ConnectionString;
    }
    catch
    {

    }
    // hart-codiert zu Testzwecken!!!
    if (CS == "") CS = @"Data Source=.\SQLEXPRESS;AttachDbFilename=h:\www\Datenbanken\WorldWideWings.mdf;Integrated Security=True;User Instance=true;";

    //if (CS == "") CS = @"Data Source=E45;Initial Catalog=WorldWideWings;Persist Security Info=True;User ID=sa;Password=sa$123";
    //Console.WriteLine("Datenbank=" + CS);
    return CS;


   }
  }


  public static System.Diagnostics.TraceSource TraceSource =
            new System.Diagnostics.TraceSource("DBTracing");

  //[System.Diagnostics.DebuggerStepThrough()]
  public static void Trace(string s)
  {
if (System.EnterpriseServices.ContextUtil.IsInTransaction)
{
    s = s + " in Transaktion " + System.EnterpriseServices.ContextUtil.TransactionId;
   }


  Console.ForegroundColor = ConsoleColor.Cyan;

   DBConfig.TraceSource.TraceEvent(System.Diagnostics.TraceEventType.Information, 2, s);
   Console.ForegroundColor = ConsoleColor.Gray;

  }

  //public const string CONN_MSSQL = @"Data Source=.\SQLEXPRESS;AttachDbFilename=E:\N2C\WorldWideWings\Datenbanken\WorldWideWings.mdf;Integrated Security=True;";
  //public const string CONN_ACCESS = @"Provider='Microsoft.Jet.OLEDB.4.0';Data Source='E:\N2C\N2C_ersteAnwendungen\N2C_JS_WebAnwendung\App_Data\WorldWideWings.mdb'";
 }
}
