using System;
using System.Collections.Generic;
using System.Text;

namespace de.WWWings
{
 /// <summary>
 /// FlugMenge ist typisierte Menge von Flug-Objekten, die mit Hilfe der Klasse <see cref="System.Collections.Generic.List"/> implementiert ist.
 /// </summary>
 public class FlugMenge : System.Collections.Generic.List<Flug>
 {
 }

 /// <summary>
 /// Klasse fr Ereignisparameter beim Paging in der Geschftslogik
 /// </summary>
 public class PagingInfo : System.EventArgs
 {
  public long AnzahlObjekteGesamt;
  public long SeitenGroesse;
  public long AnzahlSeiten;
  public long AktuelleSeite;
  public long AnzahlObjekteInAktuellerSeite;

  public PagingInfo(long AnzahlObjekteGesamt, long AnzahlSeiten, long SeitenGroesse, long AktuelleSeite, long AnzahlInAktuellerSeite)
  {
   this.AnzahlObjekteGesamt = AnzahlObjekteGesamt;
   this.AnzahlSeiten = AnzahlSeiten;
   this.SeitenGroesse = SeitenGroesse;
   this.AnzahlObjekteInAktuellerSeite = AnzahlInAktuellerSeite;
   this.AktuelleSeite = AktuelleSeite;
  }
 }

 /// <summary>
 /// FlugMenge ist typisierte Menge von Flug-Objekten, die mit Hilfe der Klasse <see cref="System.Collections.Generic.List"/> implementiert ist. Diese Variante holt immer nur eine definierbare Menge (Attribut SeitenGroesse) aus der Datenbank.
 /// </summary>
 public class FlugMengePaging : IEnumerable<Flug>
 {
  private int _SeitenGroesse = 10;

  /// <summary>
  /// Maximale Anzahl von Objekten, die in einer Datenseite abgeholt werden
  /// </summary>
  public int SeitenGroesse
  {
   get { return _SeitenGroesse; }
   set { _SeitenGroesse = value; }
  }

  // Ereignis beim Wechsel der Datenseite
  public event EventHandler<PagingInfo> SeitenWechsel;

  public FlugMengePaging(int SeitenGroesse)
  {
   this.SeitenGroesse = SeitenGroesse;
  }

  #region IEnumerable<Flug> Members

  public IEnumerator<Flug> GetEnumerator()
  {
   int Anzahl = new FlugBLManager().Count();
   int Seiten = Anzahl / SeitenGroesse;

   for (int i = 0; i < Seiten; i++)
   {
    // Nchste Datenseite abholen
    FlugMenge ff = FlugBLManager.HoleAlle(SeitenGroesse, i * SeitenGroesse + 1);
    // Ereignis auslsen
    if (SeitenWechsel != null) SeitenWechsel(this, new PagingInfo(Anzahl, Seiten, SeitenGroesse, i + 1, ff.Count));
    // Elemente der aktuellen Seite in einer Schleife zurckgeben
    foreach (Flug f in ff)
    {
     yield return f;
    }
   }
   yield break;
  }


  #endregion

  #region IEnumerable Members

  System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
  {
   throw new Exception("The method or operation is not implemented.");
  }

  #endregion
 }
}
