using System;
using System.Collections.Generic;
using System.Text;
using de.WWWings.PassagierSystem;

namespace de.WWWings
{
 public class Buchung_BLManager
 {

  /// <summary>
  /// Einzelbuchung
  /// </summary>
  public static Buchung Buchen(long PassagierNummer, long Flugnummer)
  {
   Buchung b = new Buchung(Flugnummer, PassagierNummer);
   new de.WWWings.DAL.Passagier_DataManager_ST().Buchung(b.Buchungscode, PassagierNummer, Flugnummer);
   return b;
  }

  public static Buchung Buchen(de.WWWings.Flug flug, de.WWWings.PassagierSystem.Passagier passagier)
  {
   Buchung b = new Buchung(flug, passagier);
   new de.WWWings.DAL.Passagier_DataManager_ST().Buchung(b.Buchungscode, passagier.PID, flug.FlugNr);
   return b;
  }

  /// <summary>
  /// Mehrfachbuchung (als Transaktion)
  /// </summary>
  /// <param name="Flugnummern"></param>
  public static long Buchen(long[] Flugnummern, long PassagierNummer)
  {
   Buchung b = new Buchung(Flugnummern, PassagierNummer);
    de.WWWings.DAL.Passagier_DataManager_ST.MehrfachBuchung(b.Buchungscode, PassagierNummer, Flugnummern);
    return b.Buchungscode;
   //d.Dispose();
  }

  public static long AlleBuchungenLoeschenFuerPassagier(long PassagierID)
  {
   long anz =  de.WWWings.DAL.Passagier_DataManager_ST.AlleBuchungenLoeschen(PassagierID);
   //d.Dispose();
   return anz;
  }

  public static long AlleBuchungenLoeschen()
  {
   long anz =  de.WWWings.DAL.Passagier_DataManager_ST.AlleBuchungenLoeschen();
   //d.Dispose();
   return anz;
  }

  public static long BuchungenLoeschen(long BuchungsCode)
  {
   long anz = de.WWWings.DAL.Passagier_DataManager_ST.BuchungenLoeschen(BuchungsCode);
   //d.Dispose();
   return anz;
  }

  public static BuchungsMenge HoleBuchungenFuerPassagier(long PassagierID)
  {
   return ORM.ORM_Buchung.MapTable(de.WWWings.DAL.Passagier_DataManager_ST.AlleBuchungen_DataTable(PassagierID));
  }

  public static BuchungsMenge HoleBuchungen(long Buchungscode)
  {
   return ORM.ORM_Buchung.MapTable(de.WWWings.DAL.Passagier_DataManager_ST.AlleBuchungenMitCode_DataTable(Buchungscode));
  }

  /// <summary>
  /// Zhle die Anzahl der Buchungen in der Datenbank
  /// </summary>
  /// <returns>Gesamtanzahl der Flge</returns>
  public static System.Int32 AnzahlBuchungen()
  {
   return DAL.Passagier_DataManager_ST.CountBuchungen();
  }

 }
}
