using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;

namespace de.WWWings.Workflow
{
 public sealed partial class Buchungsworkflow : SequentialWorkflowActivity
 {
  public Buchungsworkflow()
  {
   InitializeComponent();
  }

  private void A_Start_ExecuteCode(object sender, EventArgs e)
  {

   Trace("Buchungsstart...");
  }

  long PassagierNr;

  private void A_PassagierAnlegen_ExecuteCode(object sender, EventArgs e)
  {

   PassagierNr = de.WWWings.Passagier_BLManager.HolePassagierNummer(this.PersonenDaten.Name);

   if (PassagierNr != 0)
   {
    Trace(String.Format("Passagier {0} mit schon vorhanden unter ID: {1}", this.PersonenDaten.Name, PassagierNr));
   }
   else
   {
    Trace(String.Format("Passagier {0} mit E-Mail {1} wird angelegt...", this.PersonenDaten.Name, this.PersonenDaten.EMail));
    de.WWWings.Passagier_BLManager.NeuerPassagier(this.PersonenDaten.Name, this.PersonenDaten.EMail);
   }

  }

  public static DependencyProperty PersonenDatenProperty = DependencyProperty.Register("PersonenDaten", typeof(de.WWWings.Workflow.PersonenDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public PersonenDaten PersonenDaten
  {
   get
   {
    return ((de.WWWings.Workflow.PersonenDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.PersonenDatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.PersonenDatenProperty, value);
   }
  }



  private void PlaetzVerfuegbarkeitPruefen_ExecuteCode(object sender, EventArgs e)
  {
   Trace(String.Format("Prfe Platzverfgbarkeit in Workflow {0}...", this.FlugDaten.FlugNr));





  }

  private void PlaetzeBuchen_ExecuteCode(object sender, EventArgs e)
  {
   Trace(String.Format("Buche Pltze auf Flug {0}...", this.FlugDaten.FlugNr));

   de.WWWings.PassagierSystem.Passagier p;
   p = new de.WWWings.PassagierSystem.Passagier(PassagierNr);

   long b = p.Buchen(this.FlugDaten.FlugNr);

   Console.WriteLine("Buchung erfolgt! "); // + b.TicketNummer);

  }

  private void Trace(string s)
  {
   Console.ForegroundColor = ConsoleColor.Green;
   Console.Write("Workflow {0} in Thread {1}: ", this.WorkflowInstanceId, System.Threading.Thread.CurrentThread.ManagedThreadId);
   Console.ForegroundColor = ConsoleColor.White;
   Console.WriteLine(s);
  }

  private void Abbuchen_ExecuteCode(object sender, EventArgs e)
  {
   Trace("Betrag abbuchen...");
  }

  public static DependencyProperty FlugDatenProperty = DependencyProperty.Register("FlugDaten", typeof(de.WWWings.Workflow.FlugDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public FlugDaten FlugDaten
  {
   get
   {
    return ((de.WWWings.Workflow.FlugDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.FlugDatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.FlugDatenProperty, value);
   }
  }

  private void codeActivity1_ExecuteCode(object sender, EventArgs e)
  {
   DateTime Start = System.DateTime.Now;

   while (System.DateTime.Now < Start.AddSeconds(15))
   {

   }
  }

  public static DependencyProperty codeActivity1_ExecuteCode1Event = DependencyProperty.Register("codeActivity1_ExecuteCode1", typeof(System.EventHandler), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Handlers")]
  public event EventHandler codeActivity1_ExecuteCode1
  {
   add
   {
    base.AddHandler(codeActivity1_ExecuteCode1Event, value);
   }
   remove
   {
    base.RemoveHandler(codeActivity1_ExecuteCode1Event, value);
   }
  }

  private void KeinPlatz_ExecuteCode(object sender, EventArgs e)
  {
   Trace("Kein Platz auf diesem Flug!");
  }

  private void PruefeVerfuegbarkeit(object sender, ConditionalEventArgs e)
  {
   de.WWWings.Flug f = de.WWWings.FlugBLManager.HoleFlug(this.FlugDaten.FlugNr);
   Trace("Freie Pltze: " + f.FreiePlaetze);
   e.Result = (f.FreiePlaetze == 0);
  }


  public static Exception AusgebuchtFehler = new System.Exception("Flug ist ausgebucht!");
  public static DependencyProperty FlugAusgebucht_FehlerdatenProperty = DependencyProperty.Register("FlugAusgebucht_Fehlerdaten", typeof(System.Exception), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Handlers")]
  public Exception FlugAusgebucht_Fehlerdaten
  {
   get
   {
    return ((System.Exception)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.FlugAusgebucht_FehlerdatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.FlugAusgebucht_FehlerdatenProperty, value);
   }
  }

  private void Fehlerbehandlung_ExecuteCode(object sender, EventArgs e)
  {
   Trace("Nicht weiter behandelter Fehler!");
  }

  public static DependencyProperty PersonProperty = DependencyProperty.Register("Person", typeof(de.WWWings.Workflow.PersonenDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public PersonenDaten Person
  {
   get
   {
    return ((de.WWWings.Workflow.PersonenDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.PersonProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.PersonProperty, value);
   }
  }

  private void codeActivity1_ExecuteCode_1(object sender, EventArgs e)
  {

  }

 }

}
