﻿using System;
using System.Collections.Generic;
using System.Text;
using System.EnterpriseServices;

namespace de.WWWings.Test
{

 /// <summary>
 /// Info ist eine Testklasse für Enterprise Services, die Informationen für die Serviced Component an den Client liefert.
 /// </summary>
 [EventTrackingEnabled(true)]
  public class Info : System.EnterpriseServices.ServicedComponent
  {

   long Aktivierungen = 0;
   protected override void Activate()
   {
    Aktivierungen++;
   } 

   public string GetComponentInfoString()
   {
    try 
    {
     string AppID = System.EnterpriseServices.ContextUtil.ApplicationId.ToString();
     return Aktivierungen + " " + 
      String.Format("Komponente im Application Server: {0}\nInstance: {1}\nContext: {2}\n",
                                   ContextUtil.ApplicationId.ToString(), ContextUtil.ApplicationInstanceId.ToString(),
                                   ContextUtil.ContextId.ToString());
    }
    catch (Exception )
    {
     return Aktivierungen + " WWWings_DALBL not in Application Server!";
    }
}


  }



}
