﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace de.WWWings.MitarbeiterSystem
{
 /// <summary>
 /// Generische Klasse zur Erstellung einer hierarchischen Zuordnung zwischen zwei Mitarbeitern der Fluggesellschaft 
 /// </summary>
 /// <typeparam name="ChefTyp">Chef</typeparam>
 /// <typeparam name="AssistentTyp">Mitarbeiter des Chefs</typeparam>
 [System.CLSCompliant(false)]
 [Serializable()]
 public class Mitarbeiterzuordnung<ChefTyp, AssistentTyp>
  where ChefTyp : Mitarbeiter
  where AssistentTyp : Mitarbeiter
 {
  ChefTyp Chef;
  AssistentTyp Assi;

  public Mitarbeiterzuordnung(ChefTyp Chef, AssistentTyp Assi)
  {
   this.Chef = Chef;
   this.Assi = Assi;
  }

  public Mitarbeiterzuordnung()
  {
  }
 }


 class	Mitarbeiterzuordnung_Pilot_Pilot : Mitarbeiterzuordnung<Pilot,Pilot> { } 
class Mitarbeiterzuordnung_Pilot_Flugbegleiter : Mitarbeiterzuordnung<Pilot,Flugbegleiter> { }
 class Mitarbeiterzuordnung_Mitarbeiter_Mitarbeiter : Mitarbeiterzuordnung<Mitarbeiter, Mitarbeiter> { }

}
