﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.EnterpriseServices;
namespace de.WWWings
{

 /// <summary>
 /// Objekt-Stati für ORM und Caching
 /// </summary>
 enum ObjektStatus
 {
  neu,
  alt,
  eingefuegt,
  geloescht
 }

 /// <summary>
 /// Diese Klasse repräsentiert einen Flug.
 /// </summary>
 [Description("Flug-Klasse")]
 [Transaction(TransactionOption.Required)]
 [ObjectPoolingAttribute(true, 10, 20)]
 [EventTrackingEnabled(true)]
 [System.Diagnostics.DebuggerDisplay("Flug Nr={FlugNr} von {AbflugOrt} nach {ZielOrt}")]
 public partial class Flug : System.MarshalByRefObject // Vererbung nur für .NET Remoting!!!
 {

  // ========== Klassenmitglieder
  [System.CLSCompliant(true)]
  public static de.WWWings.Fluege Fluege = new de.WWWings.Fluege();

  // ========== Attribute
  private ObjektStatus Status = ObjektStatus.neu;

  private long flugNr;
  public long FlugNr
  {
   get { return flugNr; }
   set { flugNr = value; }
  }

  private string abflugOrt;
  public string AbflugOrt
  {
   get { return abflugOrt; }
   set { abflugOrt = value; }
  }

  private string zielOrt;
  public string ZielOrt
  {
   get { return zielOrt; }
   set { zielOrt = value; }
  }

  private long plaetze;
  public long Plaetze
  {
   get { return plaetze; }
   set { plaetze = value; }
  }

  private long freiePlaetze;
  public long FreiePlaetze
  {
   get { return freiePlaetze; }
   set { freiePlaetze = value; }
  }

  private bool nichtraucherflug;
  public bool Nichtraucherflug
  {
   get { return nichtraucherflug; }
   set { nichtraucherflug = value; }
  }

  private DateTime _Datum = System.DateTime.Now;


  public DateTime Datum
  {
   get { return _Datum;
   PilotBLManager b = new PilotBLManager();
   }
   set { _Datum = value; }
  }


	

  private de.WWWings.MitarbeiterSystem.Pilot pilot;
  private int MitarbeiterNr  = 0;


  /// <summary>
  /// Pilot, der das Flugzeug fliegt
  /// </summary>
  [System.Diagnostics.DebuggerDisplay("Pilot={Pilot.GanzerName}")]
  [System.Diagnostics.DebuggerBrowsable(System.Diagnostics.DebuggerBrowsableState.Collapsed)]
  public de.WWWings.MitarbeiterSystem.Pilot Pilot
  {
   get
   {
    if (pilot == null) pilot = de.WWWings.PilotBLManager.Hole(this.MitarbeiterNr);
    return pilot;
   }
  }

 }
}

