using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using de.ITVisions.DALUtil;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;

namespace de.WWWings.DAL
{

 /// <summary>
 /// Initialsierung und Test der WWWings-Datenbank
 /// </summary>
 public class DAL_TestInit
 {

  /// <summary>
  /// Zurcksetzen der Anzahl freier Pltze auf den Ursprungswert
  /// </summary>
  [AutoComplete]
  public void PlaetzeZuruecksetzen()
  {
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_FreiePlaetze = 250");
  }

  /// <summary>
  /// Setzen der freien Pltze auf Zufallszahl
  /// </summary>
  [AutoComplete]
  public void PlaetzeZufaellig()
  {
   long anz = SQLUtil.Execute("UPDATE Fl_Fluege SET FL_FreiePlaetze = " + Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(250)));
   Console.WriteLine("Rows Affected: " + anz);
  }

  /// <summary>
  /// Initialisieren der Passagiere
  /// </summary>
  [AutoComplete]
  public void InitPassagiere()
  {
   string[] Nachnamen = { "Mller", "Meier", "Schulze", "Hirsch", "Kohl", "Schrder", "Merkel", "Fischer", "Westerwelle", "Gysi" };
   string[] Vornamen = { "Max", "Hans", "Helmut", "Gerhard", "Angela", "Joschka", "Guido", "Gregor" };

   Console.WriteLine("Passagiere werden initialisiert...");
   Console.WriteLine("Anzahl Passagiere vorher: " + DBUtil.Count("Select * from PS_Passagier"));
   //DBUtil.ClearTable("GF_GebuchteFluege");
   //DBUtil.ClearTable("PS_Passagier");
   int Nummer = 1000;
   foreach (string Vorname in Vornamen)
   {
    foreach (string Nachname in Nachnamen)
    {
     //try
     //{
      DateTime Datum = DateTime.Now.AddMinutes(Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(5000)));
      Passagier_DataManager.Anlegen(Nummer, Vorname, Nachname, "DE", 1, Datum);
      System.Console.WriteLine(Nummer + ": " + Vorname + " " + Nachname);
      //System.EnterpriseServices.ContextUtil.SetComplete();
     //}
     //catch
     //{ }

     Nummer++;
    }

   }
       Console.WriteLine("Anzahl Passagiere nacher: " + DBUtil.Count("Select * from PS_Passagier"));
  }

  /// <summary>
  /// Initialisieren der Flugtabelle
  /// </summary>
  [AutoComplete]
  public void Init()
  {
   string[] Flughaefen = { "Berlin", "Frankfurt", "Mnchen", "Hamburg", "Kln/Bonn", "Rom", "London", "Paris", "Mailand", "Prag", "Moskau", "New York", "Seattle", "Essen/Mlheim", "Kapstadt", "Madrid" };
   Console.WriteLine("Tabelle FL_Fluege wird initialisiert...");
   Console.WriteLine("Anzahl Flge vorher: " + DBUtil.Count("Select * from Fl_Fluege"));
   //DBUtil.ClearTable("GF_GebuchteFluege");
   //DBUtil.ClearTable("Fl_Fluege");
   int FlugNr = 100;
   foreach (string von in Flughaefen)
   {
    foreach (string nach in Flughaefen)
    {
     try
     {
      if (von != nach)
      {
       DateTime FlugDatum = DateTime.Now.AddMinutes(Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(5000)));

       Flug_DataManager.Insert(von, nach, true, 250, Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(200)), FlugDatum, DateTime.Now, FlugNr);
       System.Console.WriteLine(FlugNr + ": " + von + "->" + nach);
       Console.WriteLine("Anzahl Flge nun: " + DBUtil.Count("Select * from Fl_Fluege"));
       System.EnterpriseServices.ContextUtil.SetComplete();

      }
     }
     catch
     { }

     FlugNr++;
    }
    Console.WriteLine("Anzahl Flge nacher: " + DBUtil.Count("Select * from Fl_Fluege"));
   }

  }

 }
}
