/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.util;

import java.lang.reflect.Method;

import org.openarchitectureware.recipe.core.CompositeCheck;

public class ElementCompositeCheck extends CompositeCheck {
	
	public ElementCompositeCheck( Object element ) {
		super( name(element), "" );
		setParameter("Element", name( element ) );
	}

	public ElementCompositeCheck( Object element, String message ) {
		super( name(element), name( element )+": "+message );
		setParameter("element", name(element));
	}

	private static String name(Object element) {
		String name = tryMethod( "QualifiedName", element );
		if ( name == null ) name = tryMethod( "NameS", element );
		if ( name == null ) name = element.toString();
		return name;
	}

	private static String tryMethod(String name, Object element) {
		try {
			Method m = element.getClass().getMethod( name, null );
			Object res = m.invoke( element, null );
			return (String)res;
		} catch (Exception ignore) {}
		return null;
	}
	
}
