/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;

public class ObjectInputStreamFactory {

	private static Class oisClass = null;
	
	public static void setOISClass( Class cls ) {
		oisClass = cls;
	}
	
	public static ObjectInputStream create( InputStream is ) throws IOException{
		if ( oisClass == null ) return new ObjectInputStream(is);
		try {
			Constructor c = oisClass.getConstructor(new Class[]{InputStream.class});
			ObjectInputStream ois = (ObjectInputStream)c.newInstance( new Object[]{is} );
			return ois;
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return new ObjectInputStream(is);
	}
	
}
