/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.checks.java;

import org.openarchitectureware.recipe.checks.file.FileExistenceCheck;

public class ClassSourceExistenceCheck extends FileExistenceCheck {
	
	public ClassSourceExistenceCheck( String message, String srcDir, String fqClassName ) {
		super( message, "" );
		setParameter( "class name", fqClassName );
		setParameter( "src dir", srcDir );
		setAbsoluteFileName( srcDir + "/" + classNameToFileName( fqClassName ) );
	}

	private String classNameToFileName(String fqClassName) {
		String s = fqClassName.replace('.','/');
		return s+".java";
	}

}
