/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.checks.java;

import org.openarchitectureware.recipe.checks.file.FileContentsHelper;
import org.openarchitectureware.recipe.eval.EvaluationContext;

public class ClassSourceContentsCheck extends ClassSourceExistenceCheck {

	private String substring;

	public ClassSourceContentsCheck( String message, String srcDir, String fqClassName, String substr ) {
		super( message, srcDir, fqClassName );
		setSubstring( substr );
	}
	
	private void setSubstring(String substr) {
		this.substring = substr;
		setParameter( "substring", substring );
	}

	public void evaluate(EvaluationContext ctx) {
		super.evaluate(ctx);
		FileContentsHelper.checkContent( this, absoluteFileName, substring );
	}

}
