/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.checks.file;

import org.openarchitectureware.recipe.eval.EvaluationContext;

public class FileContentsCheck extends FileExistenceCheck {

	private String substring;

	public FileContentsCheck( String message, String absoluteFileName, String substr ) {
		super( message, absoluteFileName );
		setSubstring( substr );
	}
	
	private void setSubstring(String substr) {
		this.substring = substr;
		setParameter( "substring", substring );
	}

	public void evaluate(EvaluationContext ctx) {
		super.evaluate(ctx);
		FileContentsHelper.checkContent( this, absoluteFileName, substring );
	}



}
