/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.ant;

import java.io.File;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.openarchitectureware.recipe.core.Check;
import org.openarchitectureware.recipe.core.CompositeCheck;
import org.openarchitectureware.recipe.core.EvalStatus;
import org.openarchitectureware.recipe.eval.CheckEvaluationListener;
import org.openarchitectureware.recipe.eval.CheckEvaluator;
import org.openarchitectureware.recipe.eval.EvaluationContext;
import org.openarchitectureware.recipe.io.CannotLoadChecksException;
import org.openarchitectureware.recipe.io.CheckRegistry;

public class RecipeCheckTask extends Task implements CheckEvaluationListener {
	
	static Logger logger = Logger.getLogger(RecipeCheckTask.class);
	private String recipeFileName;
	
	public void execute() throws BuildException {
		BasicConfigurator.configure();
		File f = new File( recipeFileName );
		if  ( !f.exists() ) {
			logger.error("recipe file not found: "+recipeFileName);
			return;
		}
		logger.info("checking recipes from file: "+recipeFileName);
		CheckRegistry.setChecksFileName( recipeFileName );
		try {
			CheckRegistry.loadFromFile();
		} catch (CannotLoadChecksException e1) {
			logger.error("cannot load recipe file: "+recipeFileName);
			return;
		}
		EvaluationContext ctx = new EvaluationContext();
		ctx.setBatchOnly(true);
		CheckEvaluator e = new CheckEvaluator(ctx);
		e.addListener( this );
		e.evaluate( CheckRegistry.getChecks() );
		
	}

	public void evaluated(Check c, boolean actuallyChecked) {
		if ( c instanceof CompositeCheck ) return; 
		if ( c.getStatus() == EvalStatus.OK ) {
			logger.debug( "[ok] "+c.getName() + " -- "+c.getShortDescription() );
		}
		if ( c.getStatus() == EvalStatus.SKIPPED ) {
			logger.debug( "[skipped] "+c.getName()+" -- "+c.getStatusMessage() );
		}
		if ( c.getStatus() == EvalStatus.FAILED ) {
			logger.error( "[error] "+c.getShortDescription()+" -- "+c.getStatusMessage() );
		}
	}
	
	public void setRecipeFile( String recipeFileName ) {
		this.recipeFileName = recipeFileName;
	}
	
	

}
