package org.openarchitectureware.adapter.gmf.constraint;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.openarchitectureware.adapter.gmf.Activator;

public class BatchValidationManager {

	private static BatchValidationManager instance;
	
	private static final int INTERVAL_TIME = 2000;

	private long lastTimeChanged;
	private Set<EObject> changedElements = new HashSet<EObject>();
	private WatchDog watchDog;

	public static BatchValidationManager instance() {
		if ( instance == null ) instance = new BatchValidationManager();
		return instance;
	}
	
	private BatchValidationManager() {
		watchDog = new WatchDog();
		watchDog.start();
	}
	
	class WatchDog extends Thread {
		@Override
		public void run() {
			while( true ) {
				try {
					sleep(INTERVAL_TIME);
				} catch (InterruptedException e) {}
				if ( lastTimeChanged < (System.currentTimeMillis()-INTERVAL_TIME) ) {
					validate();
				}
			}
		}
	}
	
	public synchronized void notify( EObject element ) {
		if ( element instanceof EPackage ) return;
		lastTimeChanged = System.currentTimeMillis();
		changedElements.add(element);
	}

	public synchronized void validate() {
		if ( changedElements.isEmpty() ) return;
		IConfigurationElement[] validateActions = Platform.getExtensionRegistry().getConfigurationElementsFor(Activator.PLUGIN_ID+".validationActions");
		for (IConfigurationElement element : validateActions) {
			OAWValidateAction oawValAct;
			try {
				oawValAct = (OAWValidateAction) element.createExecutableExtension("class");
				oawValAct.getInstance().run();
			} catch (CoreException e) {
				Activator.logError(e);
			}
		}
//		new ValidateAction(PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().getActivePart()).run();
		changedElements.clear();
	}
	
}
