header{ 	
package org.openarchitectureware.tsm.parser; 
	
import java.util.ArrayList;
import java.util.List;
import java.util.Collections;

import org.eclipse.emf.ecore.EObject;
import org.openarchitectureware.xtext.loc.LocationTool;
import org.openarchitectureware.xtext.parser.EcoreModelFactory;

}

class TextualSMParser extends Parser;

options {
	k = 6;
	defaultErrorHandler = false;     // Don't generate parser error handlers
	buildAST = false;
}

{
	private EcoreModelFactory factory;
	public TextualSMParser(TokenStream stream, EcoreModelFactory factory) {
		this(stream);
		this.factory = factory;
	}
}


ruleCompositeState returns [EObject result=null] {int start =0, line=0; List transitionsList = new ArrayList();Object a_transitions=null;List statesList = new ArrayList();Object a_states=null;List entryActionsList = new ArrayList();Object a_entryActions=null;List exitActionsList = new ArrayList();Object a_exitActions=null;}:
    { start = LT(1).getColumn()-1; line=LT(1).getLine();}
 "statemachine"
   a_name_0_0_1:ID
 TOKENI
(       a_entryActions=
 ruleAction
   {entryActionsList.add(a_entryActions);}
)*  (       a_transitions=
 ruleTransition
   {transitionsList.add(a_transitions);}
)*  (       a_exitActions=
 ruleAction
   {exitActionsList.add(a_exitActions);}
)*  (       a_states=
 ruleAbstractState
   {statesList.add(a_states);}
)*   TOKENII
	
	{ result = factory.create("new CompositeState", "setName(arg1)->transitions.addAll(arg2)->states.addAll(arg3)->entryActions.addAll(arg4)->exitActions.addAll(arg5)",a_name_0_0_1!=null ? a_name_0_0_1.getText() : null,transitionsList,statesList,entryActionsList,exitActionsList);}
	
	{ Token __t = LT(0);if (__t==null) __t = LT(1);LocationTool.setLocation(result,start,__t.getColumn()+(__t.getText()!=null?__t.getText().length()-1:0),line); }
;

ruleAbstractState returns [EObject e=null] :
   e=ruleCompositeState
   |   e=ruleState
;

ruleState returns [EObject result=null] {int start =0, line=0; List entryActionsList = new ArrayList();Object a_entryActions=null;List transitionsList = new ArrayList();Object a_transitions=null;List exitActionsList = new ArrayList();Object a_exitActions=null;}:
    { start = LT(1).getColumn()-1; line=LT(1).getLine();}
 "state"
   a_name_0_0_1:ID
 TOKENI
(       a_entryActions=
 ruleAction
   {entryActionsList.add(a_entryActions);}
)*  (       a_transitions=
 ruleTransition
   {transitionsList.add(a_transitions);}
)*  (       a_exitActions=
 ruleAction
   {exitActionsList.add(a_exitActions);}
)*   TOKENII
	
	{ result = factory.create("new State", "entryActions.addAll(arg1)->transitions.addAll(arg2)->setName(arg3)->exitActions.addAll(arg4)",entryActionsList,transitionsList,a_name_0_0_1!=null ? a_name_0_0_1.getText() : null,exitActionsList);}
	
	{ Token __t = LT(0);if (__t==null) __t = LT(1);LocationTool.setLocation(result,start,__t.getColumn()+(__t.getText()!=null?__t.getText().length()-1:0),line); }
;

ruleAction returns [EObject result=null] {int start =0, line=0; }:
    { start = LT(1).getColumn()-1; line=LT(1).getLine();}
 TOKENIII
   a_name_0_0_1:ID
	
	{ result = factory.create("new Action", "setName(arg1)",a_name_0_0_1!=null ? a_name_0_0_1.getText() : null);}
	
	{ Token __t = LT(0);if (__t==null) __t = LT(1);LocationTool.setLocation(result,start,__t.getColumn()+(__t.getText()!=null?__t.getText().length()-1:0),line); }
;

ruleTransition returns [EObject result=null] {int start =0, line=0; }:
    { start = LT(1).getColumn()-1; line=LT(1).getLine();}
   a_event_0_0_0:ID
 TOKENIIII
   a_state_0_0_2:ID
	
	{ result = factory.create("new Transition", "setState(arg1)->setEvent(arg2)",a_state_0_0_2!=null ? a_state_0_0_2.getText() : null,a_event_0_0_0!=null ? a_event_0_0_0.getText() : null);}
	
	{ Token __t = LT(0);if (__t==null) __t = LT(1);LocationTool.setLocation(result,start,__t.getColumn()+(__t.getText()!=null?__t.getText().length()-1:0),line); }
;


/////////////////////////////////////////////////////
//----------------------------------------------------------------------------
// The scanner
//----------------------------------------------------------------------------
class Scanner extends Lexer;

options {

	testLiterals=false;    // don't automatically test for literals
	k=6;                   // lookahead
	charVocabulary='\u0003'..'\uFFFE';
	codeGenBitsetTestThreshold=20;
}
{
	public void tab() {
		setColumn(getColumn()+1);
	}	
	
	public void newline() {
		int col = getColumn();
        super.newline();
    	setColumn(col);
    }
}


TOKENI : '{';

TOKENIIII : "->";

TOKENII : '}';

TOKENIII : '@';


// escape sequence -- note that this is protected; it can only be called
//   from another lexer rule -- it will not ever directly return a token to
//   the parser
// There are various ambiguities hushed in this rule.  The optional
// '0'...'9' digit matches should be matched here rather than letting
// them go back to STRING_LITERAL to be matched.  ANTLR does the
// right thing by matching immediately; hence, it's ok to shut off
// the FOLLOW ambig warnings.
protected ESC :
	'\\' ('n'|'r'|'t'|'b'|'f'|'"'|'\''|'\\'|('u')+HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT|'0'..'3'
			(options {warnWhenFollowAmbig = false;}:'0'..'7'
			(options {warnWhenFollowAmbig = false;}:'0'..'7')?
			)?
		|'4'..'7'
			(options {warnWhenFollowAmbig = false;}:
			'0'..'7')?
		)
;


// hexadecimal digit (again, note it's protected!)
protected HEX_DIGIT :
	('0'..'9'|'A'..'F'|'a'..'f')
;


// Whitespace -- ignored
WS :
	(' '|'\t'|'\f' 
	     // handle newlines
		 |(options {generateAmbigWarnings=false;}
			:	"\r\n"  // Evil DOS
			|	'\r'    // Macintosh
			|	'\n'    // Unix (the right way)
			){ newline(); }
		)+
		{ _ttype = Token.SKIP; }
	;
	






// an identifier.  Note that testLiterals is set to true!  This means
// that after we match the rule, we look in the literals table to see
// if it's a literal or really an identifer
ID options {testLiterals=true;}	:
	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
;

INT :
	('0'..'9')+ 
;

// multiple-line comments
ML_COMMENT
	:	"/*"
		({ LA(2)!='/' }? '*'
		|	'\r' '\n'		{newline();}
		|	'\r'			{newline();}
		|	'\n'			{newline();}
		|	~('*'|'\n'|'\r')
		)*
		"*/"
		{$setType(Token.SKIP);}
	;
// Single-line comments
SL_COMMENT
	:	"//"
		(~('\n'|'\r'))* ('\n'|'\r'('\n')?)
		{$setType(Token.SKIP); newline();}
	;

