package org.openarchitectureware.tsm;

import java.io.InputStreamReader;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.openarchitectureware.xtext.AbstractLanguageUtilities;
import org.openarchitectureware.tsm.TextualSMEditorPlugin;
import org.openarchitectureware.xtext.parser.EcoreModelFactory;
import org.openarchitectureware.tsm.parser.Scanner;
import org.openarchitectureware.tsm.parser.TextualSMParser;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;

public class TextualSMUtilities extends AbstractLanguageUtilities {

   public TokenStream getScanner(InputStreamReader reader) {
      return new Scanner(reader);
   }

   public EObject internalParse(TokenStream scanner, EcoreModelFactory f) throws RecognitionException, TokenStreamException {
      TextualSMParser p = new TextualSMParser(scanner, f);
      return p.ruleCompositeState();
   }

   public String getCheckFileName() {
      return "org::openarchitectureware::tsm::TextualSMChecks";
   }

   public String getFileExtension() {
      return "tsm";
   }

   public String getPathToEcoreFile() {
      return "org/openarchitectureware/tsm/textualsm.ecore";
   }

   public String getProblemId() {
      return TextualSMEditorPlugin.getDefault().getId() + ".Problem";
   }

   public String getLabelExtensionsFileName() {
      return "org::openarchitectureware::tsm::TextualSMEditorExtensions";
   }
   
   public String getImageExtensionsFileName() {
      return "org::openarchitectureware::tsm::TextualSMEditorExtensions";
   }

   public String[] allKeywords() {
      return new String[] { "statemachine","state" };
   }
   
   public ClassLoader getClassLoader() {
      return this.getClass().getClassLoader();
   }
   
   public IPartitionTokenScanner getPartitionScanner() {
      return new GeneratedPartitionScanner();
   }
}
