/**
 * <copyright>
 * </copyright>
 *
 * $Id: AbstractStateImpl.java,v 1.6 2006/08/15 13:46:11 berndkolb Exp $
 */
package statemachine2.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import statemachine2.AbstractState;
import statemachine2.Action;
import statemachine2.Statemachine2Package;
import statemachine2.Transition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract State</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link statemachine2.impl.AbstractStateImpl#getInTransitions <em>In Transitions</em>}</li>
 *   <li>{@link statemachine2.impl.AbstractStateImpl#getOutTransitions <em>Out Transitions</em>}</li>
 *   <li>{@link statemachine2.impl.AbstractStateImpl#getActions <em>Actions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AbstractStateImpl extends EObjectImpl implements AbstractState {
	/**
	 * The cached value of the '{@link #getInTransitions() <em>In Transitions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInTransitions()
	 * @generated
	 * @ordered
	 */
	protected EList inTransitions = null;

	/**
	 * The cached value of the '{@link #getOutTransitions() <em>Out Transitions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutTransitions()
	 * @generated
	 * @ordered
	 */
	protected EList outTransitions = null;

	/**
	 * The cached value of the '{@link #getActions() <em>Actions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getActions()
	 * @generated
	 * @ordered
	 */
	protected EList actions = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractStateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Statemachine2Package.Literals.ABSTRACT_STATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInTransitions() {
		if (inTransitions == null) {
			inTransitions = new EObjectWithInverseResolvingEList(Transition.class, this, Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS, Statemachine2Package.TRANSITION__TO);
		}
		return inTransitions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOutTransitions() {
		if (outTransitions == null) {
			outTransitions = new EObjectWithInverseResolvingEList(Transition.class, this, Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS, Statemachine2Package.TRANSITION__FROM);
		}
		return outTransitions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getActions() {
		if (actions == null) {
			actions = new EObjectContainmentEList(Action.class, this, Statemachine2Package.ABSTRACT_STATE__ACTIONS);
		}
		return actions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				return ((InternalEList)getInTransitions()).basicAdd(otherEnd, msgs);
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				return ((InternalEList)getOutTransitions()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				return ((InternalEList)getInTransitions()).basicRemove(otherEnd, msgs);
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				return ((InternalEList)getOutTransitions()).basicRemove(otherEnd, msgs);
			case Statemachine2Package.ABSTRACT_STATE__ACTIONS:
				return ((InternalEList)getActions()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				return getInTransitions();
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				return getOutTransitions();
			case Statemachine2Package.ABSTRACT_STATE__ACTIONS:
				return getActions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				getInTransitions().clear();
				getInTransitions().addAll((Collection)newValue);
				return;
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				getOutTransitions().clear();
				getOutTransitions().addAll((Collection)newValue);
				return;
			case Statemachine2Package.ABSTRACT_STATE__ACTIONS:
				getActions().clear();
				getActions().addAll((Collection)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				getInTransitions().clear();
				return;
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				getOutTransitions().clear();
				return;
			case Statemachine2Package.ABSTRACT_STATE__ACTIONS:
				getActions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Statemachine2Package.ABSTRACT_STATE__IN_TRANSITIONS:
				return inTransitions != null && !inTransitions.isEmpty();
			case Statemachine2Package.ABSTRACT_STATE__OUT_TRANSITIONS:
				return outTransitions != null && !outTransitions.isEmpty();
			case Statemachine2Package.ABSTRACT_STATE__ACTIONS:
				return actions != null && !actions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //AbstractStateImpl