package oaw4.demo.gmf.statemachine2.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.openarchitectureware.expression.ExpressionFacade;
import org.openarchitectureware.recipe.core.Check;
import org.openarchitectureware.recipe.eclipseChecks.checks.JavaClassExistenceCheck;
import org.openarchitectureware.recipe.eclipseChecks.checks.JavaSupertypeCheck;
import org.openarchitectureware.recipe.util.ElementCompositeCheck;

public class RecipeCreator extends AbstractExpressionRecipeCreator {

	@Override
	protected Collection internalCreateRecipes(ExpressionFacade facade,
			String project) {
		List<Check> checks = new ArrayList<Check>();
		Object sm = facade.evaluate("this");
		String name = (String) facade.evaluate("name");
		
		ElementCompositeCheck ecc = new ElementCompositeCheck(sm, "statemachine implementation must be completed.");
		checks.add( ecc );
		
		String implClassName = (String)facade.evaluate("fqImplClassName()");
		String implBaseClassName = (String)facade.evaluate("fqImplBaseClassName()");
		JavaClassExistenceCheck extCheck = new JavaClassExistenceCheck( 
				"for the State Machine "+name+" you have to provide an implemetation class named "+implClassName,
				project, implClassName );
		ecc.addChild( extCheck );
		JavaSupertypeCheck superCheck = new JavaSupertypeCheck(
				"your implementation class has to extend the generated base class "+implBaseClassName,
				project, implClassName, implBaseClassName );
		ecc.addChild( superCheck );
		return checks;
	}

}
