package statemachine2.diagram.part;

import org.eclipse.core.runtime.Platform;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

import statemachine2.Action;
import statemachine2.CompositeState;
import statemachine2.StartState;
import statemachine2.State;
import statemachine2.StateMachine;
import statemachine2.Statemachine2Package;
import statemachine2.StopState;
import statemachine2.Transition;

import statemachine2.diagram.edit.parts.Action2EditPart;
import statemachine2.diagram.edit.parts.ActionEditPart;
import statemachine2.diagram.edit.parts.Action_kind_nameEditPart;
import statemachine2.diagram.edit.parts.Action_nameEditPart;
import statemachine2.diagram.edit.parts.CompositeState2EditPart;
import statemachine2.diagram.edit.parts.CompositeStateEditPart;
import statemachine2.diagram.edit.parts.CompositeState_ActionCompartment2EditPart;
import statemachine2.diagram.edit.parts.CompositeState_ActionCompartmentEditPart;
import statemachine2.diagram.edit.parts.CompositeState_SubStateCompartment2EditPart;
import statemachine2.diagram.edit.parts.CompositeState_SubStateCompartmentEditPart;
import statemachine2.diagram.edit.parts.CompositeState_name2EditPart;
import statemachine2.diagram.edit.parts.CompositeState_nameEditPart;
import statemachine2.diagram.edit.parts.StartState2EditPart;
import statemachine2.diagram.edit.parts.StartStateEditPart;
import statemachine2.diagram.edit.parts.State2EditPart;
import statemachine2.diagram.edit.parts.StateEditPart;
import statemachine2.diagram.edit.parts.StateMachineEditPart;
import statemachine2.diagram.edit.parts.State_ActionCompartment2EditPart;
import statemachine2.diagram.edit.parts.State_ActionCompartmentEditPart;
import statemachine2.diagram.edit.parts.State_name2EditPart;
import statemachine2.diagram.edit.parts.State_nameEditPart;
import statemachine2.diagram.edit.parts.StopState2EditPart;
import statemachine2.diagram.edit.parts.StopStateEditPart;
import statemachine2.diagram.edit.parts.StopState_name2EditPart;
import statemachine2.diagram.edit.parts.StopState_nameEditPart;
import statemachine2.diagram.edit.parts.TransitionEditPart;
import statemachine2.diagram.edit.parts.Transition_name_event_guardEditPart;

/**
 * This registry is used to determine which type of visual object should be
 * created for the corresponding Diagram, Node, ChildNode or Link represented 
 * by a domain model object.
 *
 * @generated
 */
public class Statemachine2VisualIDRegistry {

	/**
	 * @generated
	 */
	private static final String DEBUG_KEY = Statemachine2DiagramEditorPlugin
			.getInstance().getBundle().getSymbolicName()
			+ "/debug/visualID"; //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static int getVisualID(View view) {
		if (view instanceof Diagram) {
			if (StateMachineEditPart.MODEL_ID.equals(view.getType())) {
				return StateMachineEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		return getVisualID(view.getType());
	}

	/**
	 * @generated
	 */
	public static String getModelID(View view) {
		View diagram = view.getDiagram();
		while (view != diagram) {
			EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
			if (annotation != null) {
				return (String) annotation.getDetails().get("modelID"); //$NON-NLS-1$
			}
			view = (View) view.eContainer();
		}
		return diagram != null ? diagram.getType() : null;
	}

	/**
	 * @generated
	 */
	public static int getVisualID(String type) {
		try {
			return Integer.parseInt(type);
		} catch (NumberFormatException e) {
			if (Boolean.TRUE.toString().equalsIgnoreCase(
					Platform.getDebugOption(DEBUG_KEY))) {
				Statemachine2DiagramEditorPlugin.getInstance().logError(
						"Unable to parse view type as a visualID number: "
								+ type);
			}
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static String getType(int visualID) {
		return String.valueOf(visualID);
	}

	/**
	 * @generated
	 */
	public static int getDiagramVisualID(EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		EClass domainElementMetaclass = domainElement.eClass();
		return getDiagramVisualID(domainElement, domainElementMetaclass);
	}

	/**
	 * @generated
	 */
	private static int getDiagramVisualID(EObject domainElement,
			EClass domainElementMetaclass) {
		if (Statemachine2Package.eINSTANCE.getStateMachine().isSuperTypeOf(
				domainElementMetaclass)
				&& isDiagramStateMachine_79((StateMachine) domainElement)) {
			return StateMachineEditPart.VISUAL_ID;
		}
		return getUnrecognizedDiagramID(domainElement);
	}

	/**
	 * @generated
	 */
	public static int getNodeVisualID(View containerView, EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		EClass domainElementMetaclass = domainElement.eClass();
		return getNodeVisualID(containerView, domainElement,
				domainElementMetaclass, null);
	}

	/**
	 * @generated
	 */
	public static int getNodeVisualID(View containerView,
			EObject domainElement, EClass domainElementMetaclass,
			String semanticHint) {
		String containerModelID = getModelID(containerView);
		if (!StateMachineEditPart.MODEL_ID.equals(containerModelID)) {
			return -1;
		}
		int containerVisualID;
		if (StateMachineEditPart.MODEL_ID.equals(containerModelID)) {
			containerVisualID = getVisualID(containerView);
		} else {
			if (containerView instanceof Diagram) {
				containerVisualID = StateMachineEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		int nodeVisualID = semanticHint != null ? getVisualID(semanticHint)
				: -1;
		switch (containerVisualID) {
		case StateEditPart.VISUAL_ID:
			if (State_nameEditPart.VISUAL_ID == nodeVisualID) {
				return State_nameEditPart.VISUAL_ID;
			}
			if (State_ActionCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return State_ActionCompartmentEditPart.VISUAL_ID;
			}
			return getUnrecognizedState_1001ChildNodeID(domainElement,
					semanticHint);
		case StartStateEditPart.VISUAL_ID:
			return getUnrecognizedStartState_1002ChildNodeID(domainElement,
					semanticHint);
		case StopStateEditPart.VISUAL_ID:
			if (StopState_nameEditPart.VISUAL_ID == nodeVisualID) {
				return StopState_nameEditPart.VISUAL_ID;
			}
			return getUnrecognizedStopState_1003ChildNodeID(domainElement,
					semanticHint);
		case CompositeStateEditPart.VISUAL_ID:
			if (CompositeState_name2EditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_name2EditPart.VISUAL_ID;
			}
			if (CompositeState_ActionCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_ActionCompartmentEditPart.VISUAL_ID;
			}
			if (CompositeState_SubStateCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_SubStateCompartmentEditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeState_1004ChildNodeID(domainElement,
					semanticHint);
		case ActionEditPart.VISUAL_ID:
			if (Action_kind_nameEditPart.VISUAL_ID == nodeVisualID) {
				return Action_kind_nameEditPart.VISUAL_ID;
			}
			return getUnrecognizedAction_2001ChildNodeID(domainElement,
					semanticHint);
		case State2EditPart.VISUAL_ID:
			if (State_name2EditPart.VISUAL_ID == nodeVisualID) {
				return State_name2EditPart.VISUAL_ID;
			}
			if (State_ActionCompartment2EditPart.VISUAL_ID == nodeVisualID) {
				return State_ActionCompartment2EditPart.VISUAL_ID;
			}
			return getUnrecognizedState_2002ChildNodeID(domainElement,
					semanticHint);
		case StartState2EditPart.VISUAL_ID:
			return getUnrecognizedStartState_2003ChildNodeID(domainElement,
					semanticHint);
		case StopState2EditPart.VISUAL_ID:
			if (StopState_name2EditPart.VISUAL_ID == nodeVisualID) {
				return StopState_name2EditPart.VISUAL_ID;
			}
			return getUnrecognizedStopState_2004ChildNodeID(domainElement,
					semanticHint);
		case CompositeState2EditPart.VISUAL_ID:
			if (CompositeState_nameEditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_nameEditPart.VISUAL_ID;
			}
			if (CompositeState_ActionCompartment2EditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_ActionCompartment2EditPart.VISUAL_ID;
			}
			if (CompositeState_SubStateCompartment2EditPart.VISUAL_ID == nodeVisualID) {
				return CompositeState_SubStateCompartment2EditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeState_2005ChildNodeID(domainElement,
					semanticHint);
		case Action2EditPart.VISUAL_ID:
			if (Action_nameEditPart.VISUAL_ID == nodeVisualID) {
				return Action_nameEditPart.VISUAL_ID;
			}
			return getUnrecognizedAction_2006ChildNodeID(domainElement,
					semanticHint);
		case State_ActionCompartmentEditPart.VISUAL_ID:
			if ((semanticHint == null || ActionEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getAction()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeAction_2001((Action) domainElement))) {
				return ActionEditPart.VISUAL_ID;
			}
			return getUnrecognizedStateActionCompartment_5001ChildNodeID(
					domainElement, semanticHint);
		case CompositeState_ActionCompartmentEditPart.VISUAL_ID:
			if ((semanticHint == null || Action2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getAction()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeAction_2006((Action) domainElement))) {
				return Action2EditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeStateActionCompartment_5002ChildNodeID(
					domainElement, semanticHint);
		case CompositeState_SubStateCompartmentEditPart.VISUAL_ID:
			if ((semanticHint == null || State2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getState().isSuperTypeOf(
							domainElementMetaclass)
					&& (domainElement == null || isNodeState_2002((State) domainElement))) {
				return State2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StartState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStartState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStartState_2003((StartState) domainElement))) {
				return StartState2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StopState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStopState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStopState_2004((StopState) domainElement))) {
				return StopState2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || CompositeState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getCompositeState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeCompositeState_2005((CompositeState) domainElement))) {
				return CompositeState2EditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeStateSubStateCompartment_5003ChildNodeID(
					domainElement, semanticHint);
		case State_ActionCompartment2EditPart.VISUAL_ID:
			if ((semanticHint == null || ActionEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getAction()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeAction_2001((Action) domainElement))) {
				return ActionEditPart.VISUAL_ID;
			}
			return getUnrecognizedStateActionCompartment_5004ChildNodeID(
					domainElement, semanticHint);
		case CompositeState_ActionCompartment2EditPart.VISUAL_ID:
			if ((semanticHint == null || Action2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getAction()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeAction_2006((Action) domainElement))) {
				return Action2EditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeStateActionCompartment_5005ChildNodeID(
					domainElement, semanticHint);
		case CompositeState_SubStateCompartment2EditPart.VISUAL_ID:
			if ((semanticHint == null || State2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getState().isSuperTypeOf(
							domainElementMetaclass)
					&& (domainElement == null || isNodeState_2002((State) domainElement))) {
				return State2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StartState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStartState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStartState_2003((StartState) domainElement))) {
				return StartState2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StopState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStopState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStopState_2004((StopState) domainElement))) {
				return StopState2EditPart.VISUAL_ID;
			}
			if ((semanticHint == null || CompositeState2EditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getCompositeState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeCompositeState_2005((CompositeState) domainElement))) {
				return CompositeState2EditPart.VISUAL_ID;
			}
			return getUnrecognizedCompositeStateSubStateCompartment_5006ChildNodeID(
					domainElement, semanticHint);
		case StateMachineEditPart.VISUAL_ID:
			if ((semanticHint == null || StateEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getState().isSuperTypeOf(
							domainElementMetaclass)
					&& (domainElement == null || isNodeState_1001((State) domainElement))) {
				return StateEditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StartStateEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStartState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStartState_1002((StartState) domainElement))) {
				return StartStateEditPart.VISUAL_ID;
			}
			if ((semanticHint == null || StopStateEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getStopState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeStopState_1003((StopState) domainElement))) {
				return StopStateEditPart.VISUAL_ID;
			}
			if ((semanticHint == null || CompositeStateEditPart.VISUAL_ID == nodeVisualID)
					&& Statemachine2Package.eINSTANCE.getCompositeState()
							.isSuperTypeOf(domainElementMetaclass)
					&& (domainElement == null || isNodeCompositeState_1004((CompositeState) domainElement))) {
				return CompositeStateEditPart.VISUAL_ID;
			}
			return getUnrecognizedStateMachine_79ChildNodeID(domainElement,
					semanticHint);
		case TransitionEditPart.VISUAL_ID:
			if (Transition_name_event_guardEditPart.VISUAL_ID == nodeVisualID) {
				return Transition_name_event_guardEditPart.VISUAL_ID;
			}
			return getUnrecognizedTransition_3001LinkLabelID(semanticHint);
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static int getLinkWithClassVisualID(EObject domainElement) {
		EClass domainElementMetaclass = domainElement.eClass();
		return getLinkWithClassVisualID(domainElement, domainElementMetaclass);
	}

	/**
	 * @generated
	 */
	public static int getLinkWithClassVisualID(EObject domainElement,
			EClass domainElementMetaclass) {
		if (Statemachine2Package.eINSTANCE.getTransition().isSuperTypeOf(
				domainElementMetaclass)
				&& (domainElement == null || isLinkWithClassTransition_3001((Transition) domainElement))) {
			return TransitionEditPart.VISUAL_ID;
		} else {
			return getUnrecognizedLinkWithClassID(domainElement);
		}
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isDiagramStateMachine_79(StateMachine element) {
		return true;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedDiagramID(EObject domainElement) {
		return -1;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeState_1001(State element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeStartState_1002(StartState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeStopState_1003(StopState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeCompositeState_1004(CompositeState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeAction_2001(Action element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeState_2002(State element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeStartState_2003(StartState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeStopState_2004(StopState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeCompositeState_2005(CompositeState element) {
		return true;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isNodeAction_2006(Action element) {
		return true;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedState_1001ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStartState_1002ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStopState_1003ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeState_1004ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedAction_2001ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedState_2002ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStartState_2003ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStopState_2004ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeState_2005ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedAction_2006ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStateActionCompartment_5001ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeStateActionCompartment_5002ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeStateSubStateCompartment_5003ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStateActionCompartment_5004ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeStateActionCompartment_5005ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedCompositeStateSubStateCompartment_5006ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedStateMachine_79ChildNodeID(
			EObject domainElement, String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedTransition_3001LinkLabelID(
			String semanticHint) {
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 *
	 * @generated
	 */
	private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
		return -1;
	}

	/**
	 * User can change implementation of this method to check some additional 
	 * conditions here.
	 *
	 * @generated
	 */
	private static boolean isLinkWithClassTransition_3001(Transition element) {
		return true;
	}
}
