package server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;


public class Server {

	public Server(int port) throws IOException {
		ServerSocket server = new ServerSocket(port);
		while (true) {
			System.out.println("Waiting for Connections...");
			Socket client = server.accept();
			System.out.println("Accepted from " + client.getInetAddress());
			ServerConnection c = addConnection(client);
			c.start();
		}
	}

	public static void main(String args[]) throws IOException {
		if (args.length != 1)
			throw new RuntimeException("Syntax: ChatServer <port>");
		new Server(Integer.parseInt(args[0]));
	}
	
	

	public ServerConnection addConnection(Socket s) {
		ServerConnection connection = new ServerConnection(s, this);
		handlers.add(connection);
		return connection;
	}

	protected Set<ServerConnection> handlers = new HashSet<ServerConnection>();

	private Set<ServerConnection> authentificatedConnections = new HashSet<ServerConnection>();

	public void broadcast(String text) {
		synchronized (handlers) {
			System.out.println("Broadcasting: " + text);
			for (ServerConnection connection : handlers) {
				if (authentificatedConnections.contains(connection))
					connection.send(text);
			}
		}
	}

	public void removeConnection(ServerConnection connection) {
		authentificatedConnections.remove(connection);
		handlers.remove(connection);
	}

	public boolean login(ServerConnection connection, String username, String password) {
		boolean success = checkLogin(username, password);
		if (success)
			authentificatedConnections.add(connection);
		return success;
	}

	private boolean checkLogin(String username, String password) {
		return true;
	}	
}
