package server;
/**
 * ChatServer.java  1.00 96/11/07 Merlin Hughes
 *
 * Copyright (c) 1996 Prominence Dot Com, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for non-commercial purposes and without fee is hereby granted
 * provided that this copyright notice appears in all copies.
 *
 * http://prominence.com/                  merlin@prominence.com
 */

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;



public class Server {

	public Server(int port) throws IOException {
		ServerSocket server = new ServerSocket(port);
		while (true) {
			System.out.println("Waiting for Connections...");
			Socket client = server.accept();
			System.out.println("Accepted from " + client.getInetAddress());
			ServerConnection c = addConnection(client);
			c.start();
		}
	}

	public static void main(String args[]) throws IOException {
		if (args.length != 1)
			throw new RuntimeException("Syntax: ChatServer <port>");
		new Server(Integer.parseInt(args[0]));
	}
	
	

	public ServerConnection addConnection(Socket s) {
		ServerConnection connection = new ServerConnection(s, this);
		handlers.add(connection);
		return connection;
	}

	protected Set<ServerConnection> handlers = new HashSet<ServerConnection>();


	public void broadcast(String text) {
		synchronized (handlers) {
			System.out.println("Broadcasting: " + text);
			for (ServerConnection connection : handlers) 
					connection.send(text);
		}
	}

	public void removeConnection(ServerConnection connection) {
		handlers.remove(connection);
	}



}
