package aspects.encryption;

import messages.Message;

public aspect Encryption {
	pointcut sendMessage(Message msg) : execution(void *.send(Message)) && args(msg);

	pointcut receiveMessage(Message msg) : 
		execution(void *.handleIncomingMessage(Message)) && args(msg) ;

	void around(Message msg): sendMessage(msg){
		msg = MessageSymmetricEncrypter.encryptMessage(msg);
		proceed(msg);
	}

	void around(Message msg): receiveMessage(msg){
		if (msg instanceof EncryptedMessage) {
			msg = MessageSymmetricEncrypter
					.decryptMessage((EncryptedMessage) msg);
		}
		proceed(msg);
	}
}
