package aspects.authentification;

import java.util.HashSet;
import java.util.Set;
import client.*;
import messages.*;

import server.Server;
import server.ServerConnection;

public privileged aspect Authentification {
	pointcut sendMessage(ServerConnection connection):call(* ServerConnection.send(..)) && target(connection);
	
	void around(ServerConnection connection, Server server):sendMessage(connection) && this(server){
		if (server.authentificatedConnections.contains(connection))
			proceed(connection,server);
	}

	private Set<ServerConnection> Server.authentificatedConnections = new HashSet<ServerConnection>();
	
	private void Client.login() {
		send(new AuthMessage("username", "password"));
	}
	after(Client client):execution(Client.new(..)) && this(client){
		client.login();
	}
	before(Server server, ServerConnection connection):execution(* Server.removeConnection(ServerConnection)) && args(connection) && this(server){
		server.authentificatedConnections.remove(connection);
	}
	
	
	public boolean Server.login(ServerConnection connection, String username, String password) {
		boolean success = checkLogin(username, password);
		if (success)
			authentificatedConnections.add(connection);
		return success;
	}
	
	private boolean Server.checkLogin(String username, String password) {
		return true;
	}
	
	after(Message msg, ServerConnection connection):execution(* ServerConnection.handleIncomingMessage(Message)) && args(msg) && this(connection){
	if (msg instanceof AuthMessage) {
		AuthMessage authMsg = (AuthMessage) msg;
		if (connection.server.login(connection, authMsg.username, authMsg.password)) {
			connection.server.broadcast(connection.name + " has authentificated.");
		} else {
			connection.send("Login denied.");
		}
	}
	}
	
}
