
from ddmin import PASS, FAIL, UNRESOLVED

def test(c):
    # Erzeuge Mozilla-Eingabedatei
    write_html(c, "input.html")

    parent = os.fork()
    if parent < 0:
        # fork() fehlgeschlagen - keine weiteren Prozesse
        sys.exit(1)

    elif not parent:
        # Mozilla aufrufen
        os.execv("/usr/bin/mozilla",
                 ["mozilla", "input.html"])

    # Benutzer-Interaktion mit xnee einspielen:
    # Seite drucken und dann Mozilla verlassen
    os.system("xnee --replay --file session.xnr")

    # Auf Mozilla warten
    childpid, status = os.waitpid(parent, 0)
    if os.WIFEXITED(status):
        exit_status = os.WEXITSTATUS(status)
        if exit_status == 0:
            return PASS     # Erfolgreicher Lauf

    if os.WIFSIGNALED(status):
        caught_signal = os.WTERMSIG(status)
        if caught_signal == 11:
            # Optional: Aufrufstapel kontrollieren
            return FAIL     # Absturz mit Signal 11

    return UNRESOLVED       # Unbekannter Lauf

