using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;

using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security;
using Microsoft.Web.Services2.Security.Tokens;

namespace WSSCService
{
	/// <summary>
	/// Summary description for Service1.
	/// </summary>
	public class SCTService : System.Web.Services.WebService
	{
		public SCTService()
		{			
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

		[WebMethod]
		public string SecureEcho(String input)
		{	
			SoapContext requestContext = RequestSoapContext.Current;
			
			// make sure only SCTs are used
			int numScts = 0;
			foreach (SecurityToken token in requestContext.Security.Tokens)
			{
				// if (token is SecurityContextToken)
				if (token is DerivedKeyToken)
					numScts++;
			}
			if (numScts != 1)
			{
				throw new SecurityFault(SecurityFault.InvalidSecurityTokenMessage, SecurityFault.InvalidSecurityTokenCode);
			}

			// check if SOAP message is signed and encrypted by the SCT
			DerivedKeyToken signatureSct = null;
			DerivedKeyToken encryptionSct = null;


			foreach ( ISecurityElement element in requestContext.Security.Elements )
            {
                if ( element is MessageSignature )
                {
                    // the given context contains a Signature element.
                    MessageSignature sig = element as MessageSignature;
                   
                    // the SOAP Body is signed.                    
					signatureSct = (DerivedKeyToken)sig.SigningToken;
                }

				if ( element is EncryptedData )
				{
					EncryptedData encryptedData = element as EncryptedData;
					System.Xml.XmlElement targetElement = encryptedData.TargetElement;										
							
					if ( SoapEnvelope.IsSoapBody(targetElement))
					{
						// The given context has the Body element Encrypted.						
						encryptionSct = (DerivedKeyToken)encryptedData.SecurityToken;
					}
				}
            }

			if (signatureSct == null || encryptionSct == null)
			{
				throw new SecurityFault(SecurityFault.InvalidSecurityMessage, SecurityFault.InvalidSecurityCode);
			}
			
			// create new derived key for response
			DerivedKeyToken dkt = new DerivedKeyToken(signatureSct.Root as IDerivableToken);

			// Use the new DerivedKeyToken to sign and encrypt the response
			SoapContext responseContext = ResponseSoapContext.Current;
			responseContext.Security.Tokens.Add(dkt);
			responseContext.Security.Elements.Add(new MessageSignature(dkt));
			responseContext.Security.Elements.Add(new EncryptedData(dkt));
			
			return "Received: " + input;
		}
	}
}
