package addressbook.web;

import addressbook.service.EmailAddress;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.application.FacesMessage;

/**
 * Vereinfachter Konverter zum Erzeugen einer Emailadresse.
 */
public class EmailAddressConverter implements Converter {

  public Object getAsObject(
      FacesContext facesContext, UIComponent component, String reference) {
    if (reference == null || reference.length() == 0) {
      return null;
    }
    String[] parts = reference.split("@");
    if (parts == null || parts.length != 2) {
      throw new ConverterException(MessageUtils.createErrorMessage(
          "converter_email_parts", facesContext));
    }
    return new EmailAddress(parts[0], parts[1]);
  }

  public String getAsString(
      FacesContext facesContext, UIComponent component, Object object) {
    return object.toString();
  }

}
