package addressbook.web;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Collections;

/**
 * Liste der verfügbaren Locales.
 */
public class Countries extends ArrayList<SelectItem> {

  public void init(Locale language) {
    clear();
    Locale[] availableLocales = Locale.getAvailableLocales();
    for (Locale locale : availableLocales) {
      String displayCountry = locale.getDisplayCountry(language);
      if (displayCountry != null && displayCountry.length() > 0) {
        add(new SelectItem(locale, displayCountry));
      }
    }
    Collections.sort(this, new SelectItemComparator());
  }

}
