package addressbook.service;

import java.util.List;

/**
 * Schnittstelle zum Anlegen, Suchen und Löschen von Adressen.
 */
public interface AddressDao {

  /**
   * Legt eine neue Adress an oder aktualisiert eine bestehende.
   */
  Address updateAddress(Address address) throws AddressDaoException;

  /**
   * Sucht Adressen, die zu dem übergebenen Filter passen.
   *
   * @param filter ist ein regulärer Ausdruck, der die Liste aller Adressen
   *               einschränkt.
   */
  List<Address> findAddresses(String filter) throws AddressDaoException;

  /**
   * Löscht die übergebene Adresse.
   */
  void removeAddress(Address address) throws AddressDaoException;

}
