<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<html>
<head>
  <title>Address List</title>
  <link rel="stylesheet" href="style.css" type="text/css"/>
</head>

<body>
<f:view>
<h:form id="f">

  <h:outputLabel for="search" value="Search" />
  <h:inputText id="search" value="#{controller.searchCriterion}"/>

  <h:commandButton action="#{controller.search}" value="Search"/>

  <h:dataTable value="#{controller.addressRows}" var="row"
      cellpadding="0" cellspacing="0"
      rowClasses="row-odd,row-even" styleClass="table">

    <h:column>
      <f:facet name="header">
        <h:outputText value=" "/>
      </f:facet>
      <h:selectBooleanCheckbox value="#{row.selected}" styleClass="checkbox"/>
    </h:column>

    <h:column>
      <f:facet name="header">
        <h:outputText value="First Name"/>
      </f:facet>
      <h:outputText value="#{row.address.firstName}"/>
    </h:column>

    <h:column>
      <f:facet name="header">
        <h:outputText value="Last Name"/>
      </f:facet>
      <h:outputText value="#{row.address.lastName}"/>
    </h:column>

  </h:dataTable>

  <h:commandButton action="#{controller.createAddress}" value="New"/>
  <h:commandButton action="#{controller.editAddress}" value="Edit"/>
  <h:commandButton action="#{controller.deleteAddresses}" value="Delete"/>

</h:form>
</f:view>
</body>
</html>