package addressbook.web;

import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Workaround, um Sonderzeichen in MyFaces zum Laufen zu bringen.
 */
public class ViewHandlerImpl extends ViewHandler {

  private static final Logger LOG = Logger.getLogger(ViewHandlerImpl.class.getName());

  private ViewHandler base;

  public ViewHandlerImpl(ViewHandler base) {
    this.base = base;
  }

  public Locale calculateLocale(FacesContext facesContext) {
    return base.calculateLocale(facesContext);
  }

  public String calculateRenderKitId(FacesContext facesContext) {
    return base.calculateRenderKitId(facesContext);
  }

  public UIViewRoot createView(FacesContext facesContext, String viewId) {
    return base.createView(facesContext, viewId);
  }

  public String getActionURL(FacesContext facesContext, String viewId) {
    return base.getActionURL(facesContext, viewId);
  }

  public String getResourceURL(FacesContext facesContext, String path) {
    return base.getResourceURL(facesContext, path);
  }


  public void renderView(FacesContext facesContext, UIViewRoot viewRoot)
      throws IOException, FacesException {
    base.renderView(facesContext, viewRoot);
  }

  public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
    handleEncoding(facesContext);
    return base.restoreView(facesContext, viewId);
  }

  private void handleEncoding(FacesContext facesContext) {
    try {
      if (facesContext.getExternalContext().getRequest() instanceof HttpServletRequest) {
        HttpServletRequest request =
            (HttpServletRequest) facesContext.getExternalContext().getRequest();
        request.setCharacterEncoding("UTF-8");
      }
      // TODO PortletRequest
    } catch (UnsupportedEncodingException e) {
      LOG.log(Level.SEVERE, null, e);
    }
  }

  public void writeState(FacesContext facesContext) throws IOException {
    base.writeState(facesContext);
  }

}

