﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
 public partial class F_Flugverwaltung_Webservice : Form
 {
  public F_Flugverwaltung_Webservice()
  {
   InitializeComponent();
  }

  private void Flugverwaltung_Webservice_Load(object sender, EventArgs e)
  {

  }

  private void openToolStripButton_Click(object sender, EventArgs e)
  {
   WWWingsServer.WorldWideWingsFlugplanWebservice ws = new WindowsUI.WWWingsServer.WorldWideWingsFlugplanWebservice();
   ws.Credentials = System.Net.CredentialCache.DefaultNetworkCredentials; 
   
   System.Data.DataSet ds = ws.GetAllFlights();
   if (ds.Tables.Count > 0) this.C_FlugTabelle.DataSource = ds.Tables[0];

   // Optional: Authentifizierung

   // Weiterleiten des aktuell angemeldeten Benutzers
   WWWingsServer.WorldWideWingsFlugplanWebservice ws1 = new
      WindowsUI.WWWingsServer.WorldWideWingsFlugplanWebservice();
   ws1.Credentials = System.Net.CredentialCache.DefaultNetworkCredentials;
   ws1.PreAuthenticate = true;
   MessageBox.Show(ws1.GetAllFlights().GetXml());

   // Explizite Identität
   WWWingsServer.WorldWideWingsFlugplanWebservice ws2 = new
   WindowsUI.WWWingsServer.WorldWideWingsFlugplanWebservice();
   ws2.Credentials = new System.Net.NetworkCredential("ar", "geheim", "ITO");
   ws2.PreAuthenticate = true;
   ws2.GetAllFlights();
   MessageBox.Show(ws2.GetAllFlights().GetXml());

   // Explizite Identität und expliziter Authentifizierungsmechanismus
   WWWingsServer.WorldWideWingsFlugplanWebservice ws3 = new
      WindowsUI.WWWingsServer.WorldWideWingsFlugplanWebservice();
   System.Net.CredentialCache cache = new System.Net.CredentialCache();
   cache.Add(new Uri(ws3.Url), "NTLM",         // Basic, Kerberos, NTLM oder Negotiate
              new System.Net.NetworkCredential("ar", "geheim", "ITO"));
   ws3.Credentials = cache;
   ws3.PreAuthenticate = true;
   ws3.GetAllFlights();
   MessageBox.Show(ws3.GetAllFlights().GetXml());
  }

  // Speichern des GridView
  private void saveToolStripButton_Click(object sender, EventArgs e)
  {
   WWWingsServer.WorldWideWingsFlugplanWebservice ws = new WindowsUI.WWWingsServer.WorldWideWingsFlugplanWebservice();
   DataSet ds, aenderungen;
   ds = ((DataTable)this.C_FlugTabelle.DataSource).DataSet;
   // Änderungen ermitteln
   if (ds.HasChanges())
   {
    aenderungen = ds.GetChanges();
    // Änderungen an Webservice übergeben
    try
    {
     ws.UpdateFlights(aenderungen);
     ds.AcceptChanges();
    }
    catch (System.Web.Services.Protocols.SoapException ex)
    {
     System.Windows.Forms.MessageBox.Show("Fehler: " + ex.Message, "Fehler beim Aufruf des Webservice");
    }
   }
  }

  private void newToolStripButton_Click(object sender, EventArgs e)
  {
   this.C_FlugTabelle.DataSource = null;
  }

  private void helpToolStripButton_Click(object sender, EventArgs e)
  {
   System.Windows.Forms.MessageBox.Show(".NET 2.0 Crashkurs. Beispiel aus dem Kapitel 'Fernaufruf/Webservices'");
  }

  private void C_FlugTabelle_CellContentClick(object sender, DataGridViewCellEventArgs e)
  {

  }

  private void C_ToolStrip_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
  {

  }



 }
}