﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using de.ITVisions.DemoViewer;

[Demo]
public class Test
{

 public void run()
 {
  Demo.Print("Test");
 }

}


public partial class _MISC_DemoViewer_CS : System.Web.UI.Page
{
 protected void Page_Load(object sender, EventArgs e)
 {
  Demo.Printing += new Demo.PrintDelegate(Demo_Printing);
  if (!Page.IsPostBack)
  {
   de.WWWings.MiscDemos.DemoRunner.RunDemosInDemoWebViewer();
   FillTree();
  }
 }

 void Demo_Printing(string s, PrintingOptions p)
 {
  if (p == PrintingOptions.Header)
  {
   C_Ausgabe.Text += "<h3>" + Server.HtmlEncode(s.Replace("\n", "<br>")) + "</h3>";
  }
  else
  {
   C_Ausgabe.Text += Server.HtmlEncode(s.Replace("\n", "<br>")) + "<br>";
  }
 }

 private void FillTree()
 {
  this.C_Ausgabe.Text = "";
  this.C_Tree.Nodes.Clear();
  long sampleCount;
  System.Collections.SortedList arlClasses = FclClassLoader.GetAllClasses(out sampleCount);

  foreach (System.Collections.DictionaryEntry de in arlClasses)
  {

   TreeNode newNode = new TreeNode(de.Value.ToString(), de.Value.ToString() + ";run");
   this.C_Tree.Nodes.Add(newNode);

   ArrayList methods = FclClassLoader.GetMethods(de.Key.ToString(), this.C_Autoruns.Checked);

   foreach (DemoMethod Method in methods)
   {
    newNode.ChildNodes.Add(new TreeNode(Method.MethodInfo.Name, de.Value.ToString() + ";" + Method.Name));
    //if (Method.AutoRun)
    //{
    // //m.ForeColor = Color.Red;
    // m.Text += " (Autorun)";
    //}
    //m.Tag = de.Key.ToString() + ";" + Method.Name;
   }
   //cbxTopic.Items.Add(s);
  }
  //this.C_TreeGruppe.Text = "Select Sample (" + sampleCount.ToString() + " Samples)";

 }
 protected void C_Tree_SelectedNodeChanged(object sender, EventArgs e)
 {
  if (C_ClearBeforeRun.Checked) this.C_Ausgabe.Text = "";
  Aufruf();
 }

 private void Aufruf()
 {

 
  // Startet das Beispiel
  string Class, Method;
  Class = C_Tree.SelectedNode.Value.ToString().Split(';')[0];
  Method = C_Tree.SelectedNode.Value.ToString().Split(';')[1];

  //this.C_Ausgabe.Text += "Running " + Class + "." + Method + "()...\n";

  this.C_StatusText.Text = "Running " + Class + "." + Method + "()...";
  long e = FclClassLoader.InvokeSample(Class, Method);
  // Beispiele voneinander abtrennen
  C_Ausgabe.Text += "\n";
  if (e == 0)
  {
   this.C_StatusText.Text = "Finished " + Class + "." + Method + "!"; this.C_StatusText.ForeColor = System.Drawing.Color.DarkGreen;
  }
  else
  {
   this.C_StatusText.Text = "Error Executing " + Class + "." + Method + "!";
   this.C_StatusText.ForeColor = System.Drawing.Color.Red;
  }
 }
 protected void C_Clear_Click(object sender, EventArgs e)
 {
  this.C_Ausgabe.Text = "";
 }
}
