Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web.UI.WebControls

Public Class ErweiterteDropDownList
  Inherits System.Web.UI.WebControls.DropDownList

  ' --- Das Label
  Dim _Label As String = "Label"

  <Category("Darstellung"), Browsable(True)> _
  Public Property Label() As String
    Get
      Return _Label
    End Get
    Set(ByVal Value As String)
      _Label = Value
    End Set
  End Property

  ' --- Position des Labels
  Enum LabelPositionsType
    Oben
    Rechts
    Links
  End Enum

  Dim _LabelPosition As LabelPositionsType = LabelPositionsType.Links

  <Category("Darstellung"), Browsable(True)> _
  Public Property LabelPosition() As LabelPositionsType
    Get
      Return _LabelPosition
    End Get
    Set(ByVal Value As LabelPositionsType)
      _LabelPosition = Value
    End Set
  End Property

  ' --- Style des Labels
  Dim _LabelStyle As String

  <Category("Darstellung"), Browsable(True)> _
  Public Property LabelStyle() As String
    Get
      Return _LabelStyle
    End Get
    Set(ByVal Value As String)
      _LabelStyle = Value
    End Set
  End Property

  ' --- Style der Textbox
  Dim _DropDownListStyle As String

  <Category("Darstellung"), Browsable(True)> _
  Public Property DropDownListStyle() As String
    Get
      Return _DropDownListStyle
    End Get
    Set(ByVal Value As String)
      _DropDownListStyle = Value
    End Set
  End Property

  Protected Overrides Sub Render(ByVal writer As HtmlTextWriter)

    Dim _LabelControl As New Label()

    ' --- Label initialisieren
    _LabelControl.Text = _Label
    If _LabelStyle <> "" Then
      _LabelControl.CssClass = _LabelStyle
    End If

    ' --- Label oben ausgeben
    If _LabelPosition = LabelPositionsType.Oben Then
      _LabelControl.RenderControl(writer)
      'writer.Write(_Label)
      writer.Write("<br>")
    End If

    ' --- Label links ausgeben
    If _LabelPosition = LabelPositionsType.Links Then
      'writer.Write(_Label)
      _LabelControl.RenderControl(writer)
      writer.Write("&nbsp;")
    End If

    ' --- Methoden der Ursprungsklasse verwenden
    If _DropDownListStyle <> "" Then
      MyBase.CssClass = _DropDownListStyle
    End If

    MyBase.Render(writer)

    ' --- Label rechts ausgeben
    If _LabelPosition = LabelPositionsType.Rechts Then
      writer.Write("&nbsp;")
      _LabelControl.RenderControl(writer)
    End If

  End Sub

End Class
