' ///////////////////////////////////////////////////////////
' /Steuerelemente/DatumZeitAnzeigeDesign.vb
' ///////////////////////////////////////////////////////////

Imports System.Web.UI
Imports System.Web.UI.Design
Imports System.Web.UI.WebControls
Imports System.ComponentModel

Public Class DatumZeitAnzeigeDesign
    Inherits ControlDesigner

    ' === Angepasste Darstellung eine Steuerelementes zur Entwurfszeit
    Public Overrides Function GetDesignTimeHtml() As String

        Dim AktuellesSteuerelement As DatumZeitAnzeige = CType(Component, DatumZeitAnzeige)

        If AktuellesSteuerelement.DatumsAnzeige = DatumZeitAnzeige.DatumFormatType.Keine And _
            AktuellesSteuerelement.UhrzeitFormat = DatumZeitAnzeige.UhrzeitFormatType.Keine _
            Then

            ' Es wird weder Uhrzeit noch Datum angezeigt.
            Return GetEmptyDesignTimeHtml()

        Else
            ' --- Sicherstellung das die ChildControls bereits erstellt 
            ' --- sind bevor der Render Vorgang beginnt.
            Dim Steuerelemente As ControlCollection = AktuellesSteuerelement.Controls
            Return MyBase.GetDesignTimeHtml()
        End If

    End Function

    ' === Ausgabe fr den Fall das ein Steuerelement keinen Inhalt darstellt
    Protected Overrides Function GetEmptyDesignTimeHtml() As String
        Dim AusgabeText As String
        AusgabeText = "Es wird weder Uhrzeit noch Datum angezeigt!"
        Return CreatePlaceHolderDesignTimeHtml(AusgabeText)
    End Function

    ' === Ausgabe fr den Fall das innerhalb des Darstellungsvorgang 
    ' === ein Fehler aufgetreten ist
    Protected Overrides Function GetErrorDesignTimeHtml(ByVal e As Exception) As String
        Dim AusgabeText As String
        AusgabeText = "Es ist ein Fehler Aufgetreten! " & e.Message
        Return CreatePlaceHolderDesignTimeHtml(AusgabeText)
    End Function

End Class
