using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;

namespace NET2.SpracheCSharp
{

 [Demo]
 public class DelegateBeispiel
 {
  // === Funktion
  public string HoleWert(long Parameter)
  {
   Demo.Print("Methodenaufruf...");
   return "Wert " + Parameter;
  }
  // === Definition eines Funktionszeigertyps
  public delegate string HoleWertDelegate(long Parameter);
  // === Hauptprogramm
  public void Test()
  {
   // --- Synchroner Aufruf
   Demo.Print("Asynchroner Aufruf...");
   Demo.Print("Ergebnis: " + HoleWert(2));
   // --- Asynchroner Aufruf
   Demo.Print("Asynchroner Aufruf...");
   HoleWertDelegate del = new HoleWertDelegate(this.HoleWert);
   AsyncCallback Callback = new AsyncCallback(Fertig);
   del.BeginInvoke(123, Callback, del);
   // --- Warten
   for (int a = 1; a <= 10; a++)
   {
    Console.Write("*");
    System.Threading.Thread.Sleep(100);
   }
   Console.ReadLine();
  }
  // === Callback-Handler
  public void Fertig(IAsyncResult CallbackResult)
  {
   Demo.Print("Aufruf fertig...");
   HoleWertDelegate del = (HoleWertDelegate)CallbackResult.AsyncState;
   string Ergebnis = del.EndInvoke(CallbackResult);
   Demo.Print("Ergebnis: " + Ergebnis);
  }
 }

}
