using System;
using System.Management;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{

 [Demo]
 public class WMI
 {

  // Informationen ber ein Betriebssystem und Reboot 
  public void WMI_Computer_Reboot()
  {
   const string COMPUTER = "E45";
   // Zugriff auf Klasse
   ManagementClass mc = new ManagementClass(@"\\" + COMPUTER + @"\root\CIMV2:Win32_OperatingSystem");
   // Instanzen holen
   ManagementObjectCollection menge = mc.GetInstances();
   // Es gibt zwar nur ein Objekt, aber man kann nicht direkt darauf zugreifen
   foreach (ManagementObject mo in menge)
   {
    Demo.Print("Informationen ber das Betriebssystem auf: " + mo.Path.Server);
    Demo.Print("Name: " + mo["Name"].ToString());
    Demo.Print("Hersteller: " + mo["Manufacturer"].ToString());
    Demo.Print("Typ: " + mo["OSType"].ToString());
    Demo.Print("Sprache: " + mo["OSLanguage"].ToString());
    Demo.Print("Version: " + mo["Version"].ToString());
    Demo.Print("Systemverzeichnis: " + mo["SystemDirectory"].ToString());
    Demo.Print("Registrierter Benutzer: " + mo["RegisteredUser"].ToString());
    Demo.PrintSubHeader("Reboot wird initiert...");
    mo.InvokeMethod("reboot", null);
    Demo.PrintSubHeader("Reboot eingeleitet!");
   }
  }

  // Auslesen von Daten ber Laufwerk C
  public void WMI_Laufwerk_Auslesen()
  {
   // WMI-Pfad
   const string pfad = @"\root\cimv2:Win32_LogicalDisk.DeviceID='C:'";

   // Zugriff auf Managed Object
   ManagementObject mo = new ManagementObject(pfad);

   // Attribute des Meta-Objekts
   Demo.PrintSubHeader("Metainformation:");
   Demo.Print("kompletter WMI-Pfad:" + mo.Path.Path);
   Demo.Print("Relativer Pfad:" + mo.Path.RelativePath);
   Demo.Print("Computer: " + mo.Path.Server);
   Demo.Print("Namespace:" + mo.Path.NamespacePath);
   Demo.Print("Standardpfad: " + ManagementPath.DefaultPath.Path);
   Demo.Print("Klassenname: " + mo.Path.ClassName);

   // Attribute des Managed Objects
   Demo.PrintSubHeader("Zugriff auf einzelne Attribute");
   Demo.Print("Name: " + mo["Caption"]);
   Demo.Print("Dateisystem: " + mo["FileSystem"]);
   Demo.Print("Freie Bytes: " + Convert.ToUInt64(mo["FreeSpace"]).ToString());
  }



  // WQL-Datenabfrage: Liste aller laufenden Dienste 
  public void WMI_Dienste_Auflisten()
  {
   // Abfragebefehl (WQL)
   const string ABFRAGE = "select name,state from Win32_Service where state='running'";
   const string COMPUTER = "E45";
  
   Demo.PrintSubHeader("WQL-Datenabfrage: Liste aller laufenden Dienste");
   ManagementScope scope = new ManagementScope("\\" + COMPUTER);
   // Abfrage erzeugen 
   SelectQuery sq = new SelectQuery(ABFRAGE);
   ManagementObjectSearcher suche = new ManagementObjectSearcher(scope, sq);
   // Abfrage ausfhren
   ManagementObjectCollection menge = suche.Get();
   // Ergebnisse ausgeben
   foreach (ManagementObject mo in menge)
    Demo.Print("Dienst: " + mo["Name"].ToString() + " Zustand: " + mo["state"].ToString());
  }

 }
}