﻿
// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.ITVisions.DemoViewer;

namespace NET2.ADONET
{
 /// <summary>
 /// Summary description for ProviderEnum.
 /// </summary>
 
 public class ReaderDatasetUmwandlung
 {
  
  public static void run()
  {

	  Demo.PrintHeader(" Konvertierung DataSet <-> DataReader");

   string CONNSTRING = DemoConfig.CONNSTRING;
   const string SQL = "Select *from FL_Fluege";

   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Datenreader erzeugen
   SqlDataReader reader = sqlCmd.ExecuteReader();

   // Konvertierung DataReader->DataSet
   Demo.Print("DataReader->DataSet...");
   DataSet ds = new DataSet();
   ds.Load(reader, LoadOption.OverwriteChanges, new String[] { "Websites" });
   Demo.Print(ds.GetXml());
   Demo.Print("DataSet->DataReader...");
   // Konvertierung DataSet->DataReader
   DataTableReader dtr = new DataTableReader(ds.Tables["Websites"]);
   Demo.PrintReader(dtr);


  }
 }


}