// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================
using System;
using System.Data.SqlClient;
using System.Data.Sql;
using System.Data;
using de.ITVisions.DemoViewer;

namespace NET2.ADONET
{

 [Demo]
 public class AsyncCommand
 {

  string CONNSTRING = DemoConfig.CONNSTRING;





  public void run_Callback()
  {
   Demo.PrintHeader("Asynchrone Ausfhrung - Callback-Modell");
   const string SQL = "Select * from Fl_Fluege";

   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;

   AsyncCallback callback = new AsyncCallback(CallbackHandler);
   sqlCmd.BeginExecuteReader(callback, sqlCmd, CommandBehavior.CloseConnection);
   //   sqlCmd.Cancel(); Beta 1: Not supported
   for (int a = 0; a <= 10000; a++)
   {
    Demo.Print(a.ToString());
    System.Windows.Forms.Application.DoEvents();
   }
  }

  //sqlCmd.Cancel();

  private static void CallbackHandler(IAsyncResult result)
  {
   Demo.PrintHeader("Callback von asynchronem Reader-Aufruf...");
   SqlCommand command = (SqlCommand)result.AsyncState;
   SqlDataReader reader = command.EndExecuteReader(result);

   Demo.Print("Hat der Befehl Zeilen geliefert? " + reader.HasRows);
   // Ausgabe der Ergebnisse
   PrintReader(reader);
  }

  // Asynchrone Befehlsausfhrung via Polling

  public void run_Polling()
  {
   Demo.PrintHeader("Asynchrone Ausfhrung - Polling");

   const string SQL = "Select *from FL_Fluege";

   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   // Befehl definieren
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Befehl starten
   IAsyncResult result = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection);
   // Warten...
   Demo.Print("Befehl abgesendet, jetzt warte ich...");
   while (!result.IsCompleted) { Demo.Print("Polling..."); }
   // Ergebnis auswerten
   SqlDataReader reader = sqlCmd.EndExecuteReader(result);
   Demo.Print("Daten (Polling):");
   PrintReader(reader);
  }

  // Asynchrone Befehlsausfhrung via WaitHandler

  public void run_Warten()
  {
   Demo.PrintHeader("Asynchrone Ausfhrung - Wartemodell");

   const string SQL = "Select * from FL_Fluege";

   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   // Befehl definieren
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Befehl starten
   IAsyncResult result = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection);
   // Warten...
   Demo.Print("Befehl abgesendet, jetzt warte ich...");
   result.AsyncWaitHandle.WaitOne();
   // Ergebnis auswerten
   SqlDataReader reader = sqlCmd.EndExecuteReader(result);
   Demo.Print("Daten (Wartemodell):");
   PrintReader(reader);
  }
  
  public static void PrintReader(IDataReader reader)
  {
   while (reader.Read())
    for (int i = 0; i < reader.FieldCount; i++)
     Demo.Print("Spalte: " + reader.GetName(i) + "\t = " + reader.GetValue(i));
  }

 }
}
