using de.WWWings;
using System.Collections.Generic; // normaler Import
using GenCol = System.Collections.Generic; // Import mit Alias
namespace de.WWWings
{

 /// <summary>
 /// Menge, die fr ODCS verwendet wird
 /// </summary>
 public class FlugMenge : GenCol.List<Flug>
 {
 }

 [System.CLSCompliant(false)]
 [System.ComponentModel.DataObject()]
 public class Fluege : GenCol.SortedList<long, Flug>
 {
  public Flug Flug
  {
   get
   {
    throw new System.NotImplementedException();
   }
   set
   {
   }
  }

  /// <summary>
  /// Typischer OR-Mapping-Code
  /// </summary>
  public static Fluege Alle()
  {
   Fluege ff = new Fluege();
   foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
   {
    Flug f = new Flug(dr);
    ff.Add(f.FlugNr, f);
   }
   return ff;
  }

  /// <summary>
  /// Weiterleiten eines DataSet
  /// </summary>
  /// <returns></returns>
  public static System.Data.DataSet AlleFluege_DS()
  {
   return DAL.Flug_DataManager.AlleFluege_DS();
  }

  /// <summary>
  /// Weiterleiten eines DataSet
  /// </summary>
  /// <returns></returns>
  public static System.Data.DataSet AlleFluege_DS(long von, long bis)
  {
   return DAL.Flug_DataManager.AlleFluege_DS(von, bis);
  }

  /// <summary>
  /// Weiterleiten eines DataSet mit Bedingung
  /// </summary>
  /// <param name="Abflugort"></param>
  /// <returns></returns>
  public static System.Data.DataSet AlleFluege_DS(string Abflugort)
  {
   return DAL.Flug_DataManager.AlleFluege_DS(Abflugort);
  }

  public static System.Data.DataSet Abflugorte()
  {
   return DAL.Flug_DataManager.Abflugort();
  }



  public static void Update_DS(System.Data.DataSet ds)
  {
   DAL.Flug_DataManager.Update(ds);
  }

 }
}