﻿using System;
using de.WWWings;

namespace de.WWWings
{
 /// <summary>
 /// ORM-Mapping für Flug-Klasse
 /// </summary>
 [System.ComponentModel.DataObject()]
 public class FlugBLManager
 {


  #region Mapping
  /// <summary>
  /// Mapping für DataRow
  /// </summary>
  public static Flug Map(System.Data.DataRow dr)
  {
   Flug f = new Flug();
   f.FlugNr = Convert.ToInt64(dr["fl_flugnr"]);
   f.AbflugOrt = dr["fl_AbflugOrt"].ToString() ?? "n/a";
   f.ZielOrt = dr["fl_ZielOrt"].ToString() ?? "n/a";
   f.Plaetze = Convert.ToInt64(dr["fl_Plaetze"].ToString() ?? "0" );
  // f.FreiePlaetze = Convert.ToInt64(dr["fl_FreiePlaetze"].ToString() ?? "0");
   return f;
  }

  /// <summary>
  /// Mapping für DataRreader
  /// </summary>
  public static Flug Map(System.Data.IDataReader dr)
  {
   Flug f = new Flug();
   f.FlugNr = Convert.ToInt64(dr["fl_flugnr"]);
   f.AbflugOrt = dr["fl_AbflugOrt"].ToString();
   f.ZielOrt = dr["fl_ZielOrt"].ToString() ?? "n/a";
   f.Plaetze = Convert.ToInt64(dr["fl_Plaetze"]);
   f.FreiePlaetze = Convert.ToInt64(dr["fl_FreiePlaetze"]);
   return f;
  }

  public static FlugMenge MapTable(System.Data.DataTable dt)
  {
   FlugMenge ff = new FlugMenge();
   foreach (System.Data.DataRow dr in dt.Rows)
   {
    Flug f = Map(dr);
    ff.Add(f);
   }
   return ff;
  }

  
  #endregion

  /// <summary>
  /// Holle alle Flüge
  /// </summary>
  /// <returns></returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle()
  {
   return MapTable(DAL.Flug_DataManager.AlleFluege_DS().Tables[0]);
  }

  /// <summary>
  /// Holle alle Flüge für einen Abflufhafen
  /// </summary>
  /// <returns></returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(string FL_Abflughafen)
  {
   return MapTable(DAL.Flug_DataManager.AlleFluege_DS(FL_Abflughafen).Tables[0]);
  }

  public System.Int32 Count()
  {
   return Fluege.AlleFluege_DS().Tables[0].Rows.Count;
  }

  /// <summary>
  /// Holle alle Flüge mit primitivem Paging
  /// </summary>
  /// <returns></returns>
  //public static FlugMenge HoleAlle(System.Int32 maximumRows, System.Int32 startRowIndex)
  //{
  // System.Int32 c = 0;
  // FlugMenge ff = new FlugMenge();
  // foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
  // {
  //  if ((c >= startRowIndex) && (c < startRowIndex + maximumRows))
  //  {
  //   Flug f = Map(dr);
  //   ff.Add(f);
  //  }
  //  c++;
  // }
  // return ff;
  //}

  /// <summary>
  /// Holle alle Flüge mit SQL 2005 Paging
  /// </summary>
  /// <returns></returns>
  public static FlugMenge HoleAlle(System.Int32 maximumRows, System.Int32 startRowIndex)
  {
   if (maximumRows == -1) return HoleAlle();
   System.Int32 c = 0;
   FlugMenge ff = new FlugMenge();
   foreach (System.Data.DataRow dr in DAL.Flug_DataManager.AlleFluege_DS(startRowIndex, startRowIndex + maximumRows).Tables[0].Rows)
   {
    Flug f = Map(dr);
    ff.Add(f);
   }
   return ff;
  }

  /// <summary>
  /// Holle alle Flüge mit SQL 2005 Paging und Sortieren!
  /// </summary>
  /// <returns></returns>
  public static FlugMenge HoleAlle(System.String sort, System.Int32 maximumRows, System.Int32 startRowIndex)
  {
   if (maximumRows == -1) return HoleAlle();
   System.Int32 c = 0;
   FlugMenge ff = new FlugMenge();
   foreach (System.Data.DataRow dr in DAL.Flug_DataManager.AlleFluege_DS(sort, startRowIndex, startRowIndex + maximumRows).Tables[0].Rows)
   {
    Flug f = Map(dr);
    ff.Add(f);
   }
   return ff;
  }


  /// <summary>
  /// Hole einen Flug
  /// </summary>
  public static de.WWWings.Flug HoleFlug(long FlugNr)
  {
   System.Data.Common.DbDataReader dr = new de.WWWings.DAL.Flug_DataManager().GetFlug_DR(FlugNr);
   Flug f = Map(dr);
   return f;
  }

  public static void Update(Flug f)
  {
  
   de.WWWings.DAL.Flug_DataManager.Update(f.AbflugOrt, f.ZielOrt, f.Plaetze, f.FlugNr);
  }

  public static void LoescheFlug(Flug f)
  {

   de.WWWings.DAL.Flug_DataManager.LoescheFlug((int) f.FlugNr);
  }

  public static void Update(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, bool FL_NichtRaucherFlug, DateTime FL_EingerichtetAm, int original_Fl_FlugNr)
  {
   de.WWWings.DAL.Flug_DataManager.Update(FL_Abflugort, FL_ZielOrt, FL_Plaetze, FL_NichtRaucherFlug, FL_EingerichtetAm, original_Fl_FlugNr);
  }
 }
}