﻿using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;
using de.ITVisions.DALUtil;

namespace de.WWWings.DAL
{
 
 [Description("DataManager für Tabelle PS_Passagiere")]
 [Transaction(TransactionOption.Required)]
 [ObjectPoolingAttribute(true, 0, 20)]
 [EventTrackingEnabled(true)]
 [System.EnterpriseServices.Synchronization(SynchronizationOption.Required)]
 [System.Runtime.InteropServices.Guid("9C74BA6A-9D1C-4fe7-808E-04E6665D0250")]
 public class Passagier_DataManager : System.EnterpriseServices.ServicedComponent, de.WWWings.DAL.IPassagier_DataManager
 {


  public Passagier_DataManager()
  {
	  DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL);
   //DBUtil.SetDatabase(DBUtil.Providers.ACCESS, CONN_ACCESS);
  }

  public Passagier_DataManager(string x)
  {
  }
  /// <summary>
  /// Führt eine einzelne Flugbuchung aus. 
  /// </summary>
  public long Buchung(long PS_ID, long FL_ID)
  {
   long RestPlaetze = 0;
   try
   {
    RestPlaetze = Buche(PS_ID, FL_ID);
    System.EnterpriseServices.ContextUtil.SetComplete();
   }
   catch (Exception ex)
   {
    System.EnterpriseServices.ContextUtil.SetAbort();
    throw ex;
   }
   return RestPlaetze;
  }

  /// <summary>
  /// Führt eine Menge von Flugbuchungen aus
  /// </summary>
  [AutoComplete]
  public void MehrfachBuchung(long PS_ID, long[] FL_IDs)
  {
   foreach (long FL_ID in FL_IDs)
   {
    Buche(PS_ID, FL_ID);
   }
  }


  /// <summary>
  /// Führt eine einzelne Flugbuchungen  aus. Erzeugt eine Ausnahme, wenn es einen Fehler gab.
  /// </summary>
  private long Buche(long PS_ID, long FL_ID)
  {
   // Prototyp: Daten tlw. statisch!
   string SQL1 = @"Select * From FL_Fluege where FL_Flugnr=" + FL_ID;
   string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (" + PS_ID + "," + FL_ID + ", 0, 'F')";
   // --- Versuche Platzanzahl zu reduzieren
   DataSet ds = DBUtil.GetDataSet(SQL1);
   if (ds.Tables[0].Rows.Count == 0) throw new ApplicationException("Flug nicht vorhanden: " + FL_ID);
   long Plaetze = Convert.ToInt32(ds.Tables[0].Rows[0]["FL_FreiePlaetze"]);
   if (Plaetze == 0) throw new ApplicationException("Keine Plätze vorhanden für Flug " + FL_ID);
   Plaetze--;
   ds.Tables[0].Rows[0]["FL_FreiePlaetze"] = Plaetze;
   try
   {
    DBUtil.UpdateDS(ds, SQL1);
   }
   catch
   {
    throw new ApplicationException("Platzreduzierung nicht erfolgreich. Flug=" + FL_ID);
   }
   // --- Versuche, Flug zu buchen
   try
   {
    DBUtil.Execute(SQL2);
   }
   catch (Exception ex)
   {
    throw new ApplicationException("Fehler beim Buchen für Flug " + FL_ID, ex);
   }
   // Alle Buchungen erfolgreich!
   return Plaetze;
  }


  [AutoComplete]
  public long AlleBuchungenLoeschen(long PS_ID)
  {
   string SQL = "Delete from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return SQLUtil.Execute(SQL);
  }

  public SqlDataReader AlleBuchungen(long PS_ID)
  {
   string SQL = "Select * from GF_GebuchteFluege where GF_PS_ID = " + PS_ID;
   return SQLUtil.GetReader(SQL);
  }

 }
}
