﻿Imports de.ITVisions.DemoViewer
Imports System.Data.SqlClient
Imports System.Xml
Imports System.IO

<Demo()> Public Class XMLWriterDemo

 Sub ExportiereFluege()

  Const CONNSTRING As String = "Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=WorldWideWings;Data Source=marl\sqlexpress"
  Const SQL As String = "Select * from FL_Fluege"
  Demo.PrintHeader("Export der Flüge (XmlWriter-Demo)")
  Dim xw As XmlWriter
  Demo.Print("Vorbereitungen...")
  ' --- Optionen für Dokument setzen 
  Dim ws As XmlWriterSettings = New XmlWriterSettings()
  ws.Indent = True
  ws.IndentChars = (ControlChars.Tab)
  ws.OmitXmlDeclaration = False
  'ws.ConformanceLevel = ConformanceLevel.Document
  'ws.CheckCharacters = True
  ' --- XMLWriter erzeugen
  xw = XmlWriter.Create("..\..\daten\Flugliste.xml", ws)
  ' --- Dokument beginnen
  xw.WriteStartDocument()
  ' --- Kommentar einfügen
  xw.WriteComment("Exportiert am/um: " & DateTime.Now)
  ' --- Wurzelelement
  xw.WriteStartElement("Fluege")
  xw.WriteAttributeString("Fluggesellschaft", "WorldWideWings")

  ' --- Datenbank öffnen
  Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
  sqlConn.Open()
  Dim sqlCmd As SqlCommand = sqlConn.CreateCommand
  sqlCmd.CommandText = SQL
  Dim dr As SqlDataReader = sqlCmd.ExecuteReader

  Demo.Print("Exportieren der Flüge...")
  While dr.Read
   xw.WriteStartElement("Flug")
   xw.WriteAttributeString("ID", dr("Fl_FlugNr").ToString())
   xw.WriteElementString("Abflugort", dr("Fl_Abflugort").ToString())
   xw.WriteElementString("Zielort", dr("Fl_Zielort").ToString())
   xw.WriteStartElement("Details")
   xw.WriteElementString("Nichtraucher", dr("Fl_Nichtraucherflug").ToString())
   xw.WriteElementString("Plaetze", dr("Fl_Plaetze").ToString())
   xw.WriteStartElement("EingerichtetAm")
   xw.WriteValue(dr("Fl_EingerichtetAm"))
   xw.WriteEndElement()
   xw.WriteEndElement()
   xw.WriteEndElement()
  End While
  ' --- Elemente schließen
  xw.WriteEndElement()
  xw.WriteEndDocument()
  ' --- Datei schließen
  xw.Close()
  ' --- Datenbank scließen
  dr.Close()
  sqlConn.Close()

  Demo.Print("Exportieren der Flüge beendet!")
 End Sub

End Class
